/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseSymmetricMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.solver.EigenDecomposition;
import org.junit.Test;

public class DenseSymmetricTest
extends MahoutTestCase {
    @Test
    public void testBasics() {
        DenseSymmetricMatrix a = new DenseSymmetricMatrix(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, false);
        System.out.println(a.toString());
        DenseSymmetricTest.assertEquals((double)0.0, (double)a.viewDiagonal().minus((Vector)new DenseVector(new double[]{1.0, 5.0, 8.0, 10.0})).norm(1.0), (double)1.0E-10);
        DenseSymmetricTest.assertEquals((double)0.0, (double)a.viewPart(0, 3, 1, 3).viewDiagonal().minus((Vector)new DenseVector(new double[]{2.0, 6.0, 9.0})).norm(1.0), (double)1.0E-10);
        DenseSymmetricTest.assertEquals((double)4.0, (double)a.get(0, 3), (double)1.0E-10);
        System.out.println(a);
        Matrix m = new DenseMatrix(4, 4).assign((Matrix)a);
        DenseSymmetricTest.assertEquals((double)0.0, (double)m.minus((Matrix)a).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        System.out.println(m);
        DenseSymmetricTest.assertEquals((double)0.0, (double)m.transpose().times(m).minus(a.transpose().times((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        System.out.println(a.plus((Matrix)a));
        DenseSymmetricTest.assertEquals((double)0.0, (double)m.plus(m).minus(a.plus((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testEigen() {
        DenseSymmetricMatrix a = new DenseSymmetricMatrix(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, false);
        DenseMatrix b = new DenseMatrix(a.numRows(), a.numCols());
        b.assign((Matrix)a);
        DenseSymmetricTest.assertEquals((double)0.0, (double)a.minus((Matrix)b).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        EigenDecomposition edA = new EigenDecomposition((Matrix)a);
        EigenDecomposition edB = new EigenDecomposition((Matrix)b);
        System.out.println(edA.getV());
        DenseSymmetricTest.assertEquals((double)0.0, (double)edA.getV().minus(edB.getV()).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        DenseSymmetricTest.assertEquals((double)0.0, (double)edA.getRealEigenvalues().minus(edA.getRealEigenvalues()).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }
}

