/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortIntProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        OpenShortIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortIntHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        OpenShortIntHashMap map2 = (OpenShortIntHashMap)map.clone();
        map.clear();
        OpenShortIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        OpenShortIntHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortIntHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        OpenShortIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenShortIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortIntHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        map.forEachPair(new ShortIntProcedure(){

            public boolean apply(short first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenShortIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenShortIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ShortIntProcedure(){
            int count = 0;

            public boolean apply(short first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        OpenShortIntHashMapTest.assertEquals((long)22L, (long)map.get((short)11));
        OpenShortIntHashMapTest.assertEquals((long)0L, (long)map.get((short)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.adjustOrPutValue((short)11, 1, 3);
        OpenShortIntHashMapTest.assertEquals((long)25L, (long)map.get((short)11));
        map.adjustOrPutValue((short)15, 1, 3);
        OpenShortIntHashMapTest.assertEquals((long)1L, (long)map.get((short)15));
    }

    @Test
    public void testKeys() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 22);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        map.pairsMatching(new ShortIntProcedure(){

            public boolean apply(short first, int second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortIntHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortIntHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenShortIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenShortIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenShortIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenShortIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        OpenShortIntHashMap map2 = (OpenShortIntHashMap)map.copy();
        map.clear();
        OpenShortIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        OpenShortIntHashMap map2 = (OpenShortIntHashMap)map.copy();
        OpenShortIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 22);
        map.put((short)12, 23);
        map.put((short)13, 24);
        map.put((short)14, 25);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortIntHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortIntHashMap map = new OpenShortIntHashMap();
        map.put((short)11, 100);
        map.put((short)12, 70);
        map.put((short)13, 30);
        map.put((short)14, 3);
        ShortArrayList keys = new ShortArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenShortIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenShortIntHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenShortIntHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortIntHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenShortIntHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenShortIntHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenShortIntHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        int v;

        Pair(short k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

