/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortByteProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        OpenShortByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortByteHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        OpenShortByteHashMap map2 = (OpenShortByteHashMap)map.clone();
        map.clear();
        OpenShortByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        OpenShortByteHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortByteHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        OpenShortByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenShortByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortByteHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        map.forEachPair(new ShortByteProcedure(){

            public boolean apply(short first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenShortByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenShortByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ShortByteProcedure(){
            int count = 0;

            public boolean apply(short first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        OpenShortByteHashMapTest.assertEquals((long)22L, (long)map.get((short)11));
        OpenShortByteHashMapTest.assertEquals((long)0L, (long)map.get((short)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.adjustOrPutValue((short)11, (byte)1, (byte)3);
        OpenShortByteHashMapTest.assertEquals((long)25L, (long)map.get((short)11));
        map.adjustOrPutValue((short)15, (byte)1, (byte)3);
        OpenShortByteHashMapTest.assertEquals((long)1L, (long)map.get((short)15));
    }

    @Test
    public void testKeys() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)22);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        map.pairsMatching(new ShortByteProcedure(){

            public boolean apply(short first, byte second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortByteHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortByteHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenShortByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenShortByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenShortByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenShortByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        OpenShortByteHashMap map2 = (OpenShortByteHashMap)map.copy();
        map.clear();
        OpenShortByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        OpenShortByteHashMap map2 = (OpenShortByteHashMap)map.copy();
        OpenShortByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)22);
        map.put((short)12, (byte)23);
        map.put((short)13, (byte)24);
        map.put((short)14, (byte)25);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortByteHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortByteHashMap map = new OpenShortByteHashMap();
        map.put((short)11, (byte)100);
        map.put((short)12, (byte)70);
        map.put((short)13, (byte)30);
        map.put((short)14, (byte)3);
        ShortArrayList keys = new ShortArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenShortByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenShortByteHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenShortByteHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortByteHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenShortByteHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenShortByteHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenShortByteHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        byte v;

        Pair(short k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

