/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntFloatProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        OpenIntFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntFloatHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        OpenIntFloatHashMap map2 = (OpenIntFloatHashMap)map.clone();
        map.clear();
        OpenIntFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        OpenIntFloatHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntFloatHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        OpenIntFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenIntFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntFloatHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        map.forEachPair(new IntFloatProcedure(){

            public boolean apply(int first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntFloatHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntFloatHashMapTest.assertEquals((float)22.0f, (float)((Pair)pairs.get((int)0)).v, (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntFloatHashMapTest.assertEquals((float)23.0f, (float)((Pair)pairs.get((int)1)).v, (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntFloatHashMapTest.assertEquals((float)25.0f, (float)((Pair)pairs.get((int)2)).v, (float)1.0E-6f);
        pairs.clear();
        map.forEachPair(new IntFloatProcedure(){
            int count = 0;

            public boolean apply(int first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        OpenIntFloatHashMapTest.assertEquals((float)22.0f, (float)map.get(11), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((float)0.0f, (float)map.get(0), (float)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.adjustOrPutValue(11, 1.0f, 3.0f);
        OpenIntFloatHashMapTest.assertEquals((float)25.0f, (float)map.get(11), (float)1.0E-6f);
        map.adjustOrPutValue(15, 1.0f, 3.0f);
        OpenIntFloatHashMapTest.assertEquals((float)1.0f, (float)map.get(15), (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 22.0f);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        map.pairsMatching(new IntFloatProcedure(){

            public boolean apply(int first, float second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntFloatHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntFloatHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntFloatHashMapTest.assertEquals((float)23.0f, (float)valueList.get(0), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((float)25.0f, (float)valueList.get(1), (float)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenIntFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntFloatHashMapTest.assertEquals((float)22.0f, (float)values.get(0), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((float)23.0f, (float)values.get(1), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((float)25.0f, (float)values.get(2), (float)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        OpenIntFloatHashMap map2 = (OpenIntFloatHashMap)map.copy();
        map.clear();
        OpenIntFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        OpenIntFloatHashMap map2 = (OpenIntFloatHashMap)map.copy();
        OpenIntFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 22.0f);
        map.put(12, 23.0f);
        map.put(13, 24.0f);
        map.put(14, 25.0f);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntFloatHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntFloatHashMap map = new OpenIntFloatHashMap();
        map.put(11, 100.0f);
        map.put(12, 70.0f);
        map.put(13, 30.0f);
        map.put(14, 3.0f);
        IntArrayList keys = new IntArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(0), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(1), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(2), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(3), (float)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntFloatHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(3), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(2), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(1), (float)1.0E-6f);
        OpenIntFloatHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(0), (float)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        float v;

        Pair(int k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

