/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntDoubleProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        OpenIntDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        OpenIntDoubleHashMap map2 = (OpenIntDoubleHashMap)map.clone();
        map.clear();
        OpenIntDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        OpenIntDoubleHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntDoubleHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        OpenIntDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenIntDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntDoubleHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        map.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntDoubleHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new IntDoubleProcedure(){
            int count = 0;

            public boolean apply(int first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        OpenIntDoubleHashMapTest.assertEquals((double)22.0, (double)map.get(11), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((double)0.0, (double)map.get(0), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.adjustOrPutValue(11, 1.0, 3.0);
        OpenIntDoubleHashMapTest.assertEquals((double)25.0, (double)map.get(11), (double)1.0E-6);
        map.adjustOrPutValue(15, 1.0, 3.0);
        OpenIntDoubleHashMapTest.assertEquals((double)1.0, (double)map.get(15), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 22.0);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        map.pairsMatching(new IntDoubleProcedure(){

            public boolean apply(int first, double second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntDoubleHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntDoubleHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenIntDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        OpenIntDoubleHashMap map2 = (OpenIntDoubleHashMap)map.copy();
        map.clear();
        OpenIntDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        OpenIntDoubleHashMap map2 = (OpenIntDoubleHashMap)map.copy();
        OpenIntDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 22.0);
        map.put(12, 23.0);
        map.put(13, 24.0);
        map.put(14, 25.0);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntDoubleHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntDoubleHashMap map = new OpenIntDoubleHashMap();
        map.put(11, 100.0);
        map.put(12, 70.0);
        map.put(13, 30.0);
        map.put(14, 3.0);
        IntArrayList keys = new IntArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenIntDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        double v;

        Pair(int k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

