/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.FloatShortProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenFloatShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        OpenFloatShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatShortHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        OpenFloatShortHashMap map2 = (OpenFloatShortHashMap)map.clone();
        map.clear();
        OpenFloatShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        OpenFloatShortHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatShortHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        OpenFloatShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenFloatShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatShortHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        map.forEachPair(new FloatShortProcedure(){

            public boolean apply(float first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatShortHashMapTest.assertEquals((float)11.0f, (float)((Pair)pairs.get((int)0)).k, (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenFloatShortHashMapTest.assertEquals((float)12.0f, (float)((Pair)pairs.get((int)1)).k, (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenFloatShortHashMapTest.assertEquals((float)14.0f, (float)((Pair)pairs.get((int)2)).k, (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new FloatShortProcedure(){
            int count = 0;

            public boolean apply(float first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        OpenFloatShortHashMapTest.assertEquals((long)22L, (long)map.get(11.0f));
        OpenFloatShortHashMapTest.assertEquals((long)0L, (long)map.get(0.0f));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.adjustOrPutValue(11.0f, (short)1, (short)3);
        OpenFloatShortHashMapTest.assertEquals((long)25L, (long)map.get(11.0f));
        map.adjustOrPutValue(15.0f, (short)1, (short)3);
        OpenFloatShortHashMapTest.assertEquals((long)1L, (long)map.get(15.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)22);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatShortHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatShortProcedure(){

            public boolean apply(float first, short second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatShortHashMapTest.assertEquals((float)12.0f, (float)keyList.get(0), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((float)14.0f, (float)keyList.get(1), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenFloatShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenFloatShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenFloatShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenFloatShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        OpenFloatShortHashMap map2 = (OpenFloatShortHashMap)map.copy();
        map.clear();
        OpenFloatShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        OpenFloatShortHashMap map2 = (OpenFloatShortHashMap)map.copy();
        OpenFloatShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)22);
        map.put(12.0f, (short)23);
        map.put(13.0f, (short)24);
        map.put(14.0f, (short)25);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatShortHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatShortHashMap map = new OpenFloatShortHashMap();
        map.put(11.0f, (short)100);
        map.put(12.0f, (short)70);
        map.put(13.0f, (short)30);
        map.put(14.0f, (short)3);
        FloatArrayList keys = new FloatArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatShortHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenFloatShortHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenFloatShortHashMapTest.assertEquals((float)13.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenFloatShortHashMapTest.assertEquals((float)14.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatShortHashMapTest.assertEquals((float)11.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenFloatShortHashMapTest.assertEquals((float)12.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenFloatShortHashMapTest.assertEquals((float)13.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenFloatShortHashMapTest.assertEquals((float)14.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        short v;

        Pair(float k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

