/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteCharProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.OpenByteCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteCharHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        OpenByteCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteCharHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenByteCharHashMapTest.assertEquals((double)0.0, (double)map.get((byte)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        OpenByteCharHashMap map2 = (OpenByteCharHashMap)map.clone();
        map.clear();
        OpenByteCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        OpenByteCharHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteCharHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        OpenByteCharHashMapTest.assertTrue((boolean)map.containsValue('\u0016'));
        OpenByteCharHashMapTest.assertFalse((boolean)map.containsValue('\u0017'));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteCharHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        map.forEachPair(new ByteCharProcedure(){

            public boolean apply(byte first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteCharHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenByteCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteCharHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenByteCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteCharHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ByteCharProcedure(){
            int count = 0;

            public boolean apply(byte first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        OpenByteCharHashMapTest.assertEquals((long)22L, (long)map.get((byte)11));
        OpenByteCharHashMapTest.assertEquals((long)0L, (long)map.get((byte)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.adjustOrPutValue((byte)11, '\u0001', '\u0003');
        OpenByteCharHashMapTest.assertEquals((long)25L, (long)map.get((byte)11));
        map.adjustOrPutValue((byte)15, '\u0001', '\u0003');
        OpenByteCharHashMapTest.assertEquals((long)1L, (long)map.get((byte)15));
    }

    @Test
    public void testKeys() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0016');
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteCharHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        map.pairsMatching(new ByteCharProcedure(){

            public boolean apply(byte first, char second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenByteCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteCharHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteCharHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteCharHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenByteCharHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenByteCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenByteCharHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenByteCharHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenByteCharHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        OpenByteCharHashMap map2 = (OpenByteCharHashMap)map.copy();
        map.clear();
        OpenByteCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        OpenByteCharHashMap map2 = (OpenByteCharHashMap)map.copy();
        OpenByteCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, '\u0016');
        map.put((byte)12, '\u0017');
        map.put((byte)13, '\u0018');
        map.put((byte)14, '\u0019');
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteCharHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteCharHashMap map = new OpenByteCharHashMap();
        map.put((byte)11, 'd');
        map.put((byte)12, 'F');
        map.put((byte)13, '\u001e');
        map.put((byte)14, '\u0003');
        ByteArrayList keys = new ByteArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteCharHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteCharHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenByteCharHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteCharHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenByteCharHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteCharHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenByteCharHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteCharHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenByteCharHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteCharHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenByteCharHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteCharHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenByteCharHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteCharHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenByteCharHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteCharHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        char v;

        Pair(byte k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

