/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.CholeskyDecomposition;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.PivotedMatrix;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.junit.Assert;
import org.junit.Test;

public class CholeskyDecompositionTest
extends MahoutTestCase {
    @Test
    public void rank1() {
        DenseMatrix x = new DenseMatrix(3, 3);
        x.viewRow(0).assign(new double[]{1.0, 2.0, 3.0});
        x.viewRow(1).assign(new double[]{2.0, 4.0, 6.0});
        x.viewRow(2).assign(new double[]{3.0, 6.0, 9.0});
        CholeskyDecomposition rr = new CholeskyDecomposition(x.transpose().times((Matrix)x), false);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)new DenseVector(new double[]{3.741657, 7.483315, 11.22497}).aggregate(rr.getL().transpose().viewRow(0), Functions.PLUS, new DoubleDoubleFunction(){

            public double apply(double arg1, double arg2) {
                return Math.abs(arg1) - Math.abs(arg2);
            }
        }), (double)1.0E-5);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)rr.getL().viewPart(0, 3, 1, 2).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-9);
    }

    @Test
    public void test1() {
        RandomWrapper rand = RandomUtils.getRandom();
        DenseMatrix z = new DenseMatrix(100, 100);
        z.assign(new DoubleFunction((Random)rand){
            final /* synthetic */ Random val$rand;
            {
                this.val$rand = random;
            }

            public double apply(double arg1) {
                return this.val$rand.nextDouble();
            }
        });
        Matrix A = z.times(z.transpose());
        boolean type = false;
        while (!type) {
            int i;
            CholeskyDecomposition cd = new CholeskyDecomposition(A, type);
            Matrix L = cd.getL();
            Matrix Abar = L.times(L.transpose());
            double error = A.minus(Abar).aggregate(Functions.MAX, Functions.ABS);
            Assert.assertEquals((String)("type = " + type), (double)0.0, (double)error, (double)1.0E-10);
            Matrix q = cd.solveLeft((Matrix)z);
            Matrix id = q.times(q.transpose());
            for (i = 0; i < id.columnSize(); ++i) {
                Assert.assertEquals((String)("type = " + type), (double)1.0, (double)id.get(i, i), (double)1.0E-9);
                Assert.assertEquals((String)("type = " + type), (double)1.0, (double)id.viewRow(i).norm(1.0), (double)1.0E-9);
            }
            q = cd.solveRight(z.transpose());
            id = q.transpose().times(q);
            for (i = 0; i < id.columnSize(); ++i) {
                Assert.assertEquals((String)("type = " + type), (double)1.0, (double)id.get(i, i), (double)1.0E-9);
                Assert.assertEquals((String)("type = " + type), (double)1.0, (double)id.viewRow(i).norm(1.0), (double)1.0E-9);
            }
            type = true;
        }
    }

    @Test
    public void test2() {
        double[][] values = new double[][]{{1.0, -1.0, 1.0}, {-1.0, 1.0, -1.0}, {1.0, -1.0, 2.0}};
        DenseMatrix A = new DenseMatrix((double[][])values);
        CholeskyDecomposition cd = new CholeskyDecomposition((Matrix)A, false);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)cd.getL().times(cd.getL().transpose()).minus((Matrix)A).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        cd = new CholeskyDecomposition((Matrix)A);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)cd.getL().times(cd.getL().transpose()).minus((Matrix)A).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testRankDeficient() {
        Matrix A = CholeskyDecompositionTest.rank4Matrix();
        CholeskyDecomposition cd = new CholeskyDecomposition(A);
        PivotedMatrix Ax = new PivotedMatrix(A, cd.getPivot());
        CholeskyDecomposition cd2 = new CholeskyDecomposition((Matrix)Ax, false);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)cd2.getL().times(cd2.getL().transpose()).minus((Matrix)Ax).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        CholeskyDecompositionTest.assertEquals((double)0.0, (double)cd.getL().times(cd.getL().transpose()).minus(A).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        Assert.assertFalse((boolean)cd.isPositiveDefinite());
        Matrix L = cd.getL();
        Matrix Abar = L.times(L.transpose());
        double error = A.minus(Abar).aggregate(Functions.MAX, Functions.ABS);
        Assert.assertEquals((double)0.0, (double)error, (double)1.0E-10);
    }

    private static Matrix rank4Matrix() {
        RandomWrapper rand = RandomUtils.getRandom();
        DenseMatrix u = new DenseMatrix(10, 4);
        u.assign(new DoubleFunction((Random)rand){
            final /* synthetic */ Random val$rand;
            {
                this.val$rand = random;
            }

            public double apply(double arg1) {
                return this.val$rand.nextDouble();
            }
        });
        DenseMatrix v = new DenseMatrix(10, 4);
        v.assign(new DoubleFunction((Random)rand){
            final /* synthetic */ Random val$rand;
            {
                this.val$rand = random;
            }

            public double apply(double arg1) {
                return this.val$rand.nextDouble();
            }
        });
        Matrix z = u.times(v.transpose());
        return z.times(z.transpose());
    }
}

