/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.Bump125;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.utils.vectors.lucene.LuceneIterator;
import org.apache.mahout.utils.vectors.lucene.TFDFMapper;
import org.apache.mahout.vectorizer.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLuceneIterator
extends AbstractIterator<Vector> {
    private static final Logger log = LoggerFactory.getLogger(LuceneIterator.class);
    protected final IndexReader indexReader;
    protected final String field;
    protected final TermInfo terminfo;
    protected final double normPower;
    protected final Weight weight;
    protected final Bump125 bump = new Bump125();
    protected int nextDocId;
    protected int maxErrorDocs;
    protected int numErrorDocs;
    protected long nextLogRecord = this.bump.increment();
    protected int skippedErrorMessages;

    public AbstractLuceneIterator(TermInfo terminfo, double normPower, IndexReader indexReader, Weight weight, double maxPercentErrorDocs, String field) {
        this.terminfo = terminfo;
        this.normPower = normPower;
        this.indexReader = indexReader;
        this.weight = weight;
        this.nextDocId = 0;
        this.maxErrorDocs = (int)(maxPercentErrorDocs * (double)indexReader.numDocs());
        this.field = field;
    }

    protected abstract String getVectorName(int var1) throws IOException;

    protected Vector computeNext() {
        try {
            BytesRef term;
            String name;
            Terms termFreqVector;
            do {
                int doc;
                if ((doc = this.nextDocId++) >= this.indexReader.maxDoc()) {
                    return (Vector)this.endOfData();
                }
                termFreqVector = this.indexReader.getTermVector(doc, this.field);
                name = this.getVectorName(doc);
                if (termFreqVector != null) continue;
                ++this.numErrorDocs;
                if (this.numErrorDocs >= this.maxErrorDocs) {
                    log.error("There are too many documents that do not have a term vector for {}", (Object)this.field);
                    throw new IllegalStateException("There are too many documents that do not have a term vector for " + this.field);
                }
                if ((long)this.numErrorDocs >= this.nextLogRecord) {
                    if (this.skippedErrorMessages == 0) {
                        log.warn("{} does not have a term vector for {}", (Object)name, (Object)this.field);
                    } else {
                        log.warn("{} documents do not have a term vector for {}", (Object)this.numErrorDocs, (Object)this.field);
                    }
                    this.nextLogRecord = this.bump.increment();
                    this.skippedErrorMessages = 0;
                    continue;
                }
                ++this.skippedErrorMessages;
            } while (termFreqVector == null);
            TermsEnum te = termFreqVector.iterator(null);
            TFDFMapper mapper = new TFDFMapper(this.indexReader.numDocs(), this.weight, this.terminfo);
            mapper.setExpectations(this.field, termFreqVector.size());
            while ((term = te.next()) != null) {
                mapper.map(term, (int)te.totalTermFreq());
            }
            Vector result = mapper.getVector();
            if (result == null) {
                return null;
            }
            result = this.normPower == -1.0 ? new NamedVector(result, name) : new NamedVector(result.normalize(this.normPower), name);
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

