/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.regex;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mahout.utils.regex.IdentityFormatter;
import org.apache.mahout.utils.regex.IdentityTransformer;
import org.apache.mahout.utils.regex.RegexFormatter;
import org.apache.mahout.utils.regex.RegexTransformer;

public final class RegexUtils {
    public static final RegexTransformer IDENTITY_TRANSFORMER = new IdentityTransformer();
    public static final RegexFormatter IDENTITY_FORMATTER = new IdentityFormatter();

    private RegexUtils() {
    }

    public static String extract(CharSequence line, Pattern pattern, Collection<Integer> groupsToKeep, String separator, RegexTransformer transformer) {
        StringBuilder bldr = new StringBuilder();
        RegexUtils.extract(line, bldr, pattern, groupsToKeep, separator, transformer);
        return bldr.toString();
    }

    public static void extract(CharSequence line, StringBuilder outputBuffer, Pattern pattern, Collection<Integer> groupsToKeep, String separator, RegexTransformer transformer) {
        if (transformer == null) {
            transformer = IDENTITY_TRANSFORMER;
        }
        Matcher matcher = pattern.matcher(line);
        if (groupsToKeep.isEmpty()) {
            while (matcher.find()) {
                String match = matcher.group();
                if (match == null) continue;
                outputBuffer.append(transformer.transformMatch(match)).append(separator);
            }
        } else {
            while (matcher.find()) {
                for (Integer groupNum : groupsToKeep) {
                    String match = matcher.group(groupNum);
                    if (match == null) continue;
                    outputBuffer.append(transformer.transformMatch(match)).append(separator);
                }
            }
        }
        if (outputBuffer.length() > 0) {
            outputBuffer.setLength(outputBuffer.length() - separator.length());
        }
    }
}

