/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class WholeFileRecordReader
extends RecordReader<IntWritable, BytesWritable> {
    private FileSplit fileSplit;
    private boolean processed = false;
    private Configuration configuration;
    private BytesWritable value = new BytesWritable();
    private IntWritable index;

    public WholeFileRecordReader(CombineFileSplit fileSplit, TaskAttemptContext taskAttemptContext, Integer idx) throws IOException {
        this.fileSplit = new FileSplit(fileSplit.getPath(idx.intValue()), fileSplit.getOffset(idx.intValue()), fileSplit.getLength(idx.intValue()), fileSplit.getLocations());
        this.configuration = taskAttemptContext.getConfiguration();
        this.index = new IntWritable(idx.intValue());
    }

    public IntWritable getCurrentKey() {
        return this.index;
    }

    public BytesWritable getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException {
        return this.processed ? 1.0f : 0.0f;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextKeyValue() throws IOException {
        block4: {
            FSDataInputStream in;
            FileSystem fs;
            Path file;
            byte[] contents;
            block3: {
                boolean bl;
                if (this.processed) break block4;
                contents = new byte[(int)this.fileSplit.getLength()];
                file = this.fileSplit.getPath();
                fs = file.getFileSystem(this.configuration);
                in = null;
                try {
                    if (fs.isFile(file)) break block3;
                    bl = false;
                }
                catch (Throwable throwable) {
                    Closeables.close(in, (boolean)false);
                    throw throwable;
                }
                Closeables.close(in, (boolean)false);
                return bl;
            }
            in = fs.open(file);
            IOUtils.readFully((InputStream)in, (byte[])contents, (int)0, (int)contents.length);
            this.value.setCapacity(contents.length);
            this.value.set(contents, 0, contents.length);
            Closeables.close((Closeable)in, (boolean)false);
            this.processed = true;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
    }
}

