/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;

public class LuceneStorageConfiguration
implements Writable {
    private static final Query DEFAULT_QUERY = new MatchAllDocsQuery();
    private static final int DEFAULT_MAX_HITS = Integer.MAX_VALUE;
    static final String KEY = "org.apache.mahout.text.LuceneIndexToSequenceFiles";
    static final String SEPARATOR_FIELDS = ",";
    static final String SEPARATOR_PATHS = ",";
    private Configuration configuration;
    private List<Path> indexPaths;
    private Path sequenceFilesOutputPath;
    private String idField;
    private List<String> fields;
    private Query query;
    private int maxHits;

    public LuceneStorageConfiguration(Configuration configuration, List<Path> indexPaths, Path sequenceFilesOutputPath, String idField, List<String> fields) {
        Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"Parameter 'configuration' cannot be null");
        Preconditions.checkArgument((indexPaths != null ? 1 : 0) != 0, (Object)"Parameter 'indexPaths' cannot be null");
        Preconditions.checkArgument((indexPaths != null && !indexPaths.isEmpty() ? 1 : 0) != 0, (Object)"Parameter 'indexPaths' cannot be empty");
        Preconditions.checkArgument((sequenceFilesOutputPath != null ? 1 : 0) != 0, (Object)"Parameter 'sequenceFilesOutputPath' cannot be null");
        Preconditions.checkArgument((idField != null ? 1 : 0) != 0, (Object)"Parameter 'idField' cannot be null");
        Preconditions.checkArgument((fields != null ? 1 : 0) != 0, (Object)"Parameter 'fields' cannot be null");
        Preconditions.checkArgument((fields != null && !fields.isEmpty() ? 1 : 0) != 0, (Object)"Parameter 'fields' cannot be empty");
        this.configuration = configuration;
        this.indexPaths = indexPaths;
        this.sequenceFilesOutputPath = sequenceFilesOutputPath;
        this.idField = idField;
        this.fields = fields;
        this.setQuery(DEFAULT_QUERY);
        this.setMaxHits(Integer.MAX_VALUE);
    }

    public LuceneStorageConfiguration() {
    }

    public LuceneStorageConfiguration(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"Parameter 'configuration' cannot be null");
        String serializedConfigString = conf.get(KEY);
        if (serializedConfigString == null) {
            throw new IllegalArgumentException("Parameter 'configuration' does not contain a serialized " + this.getClass());
        }
        LuceneStorageConfiguration luceneStorageConf = (LuceneStorageConfiguration)DefaultStringifier.load((Configuration)conf, (String)KEY, LuceneStorageConfiguration.class);
        this.configuration = conf;
        this.indexPaths = luceneStorageConf.getIndexPaths();
        this.sequenceFilesOutputPath = luceneStorageConf.getSequenceFilesOutputPath();
        this.idField = luceneStorageConf.getIdField();
        this.fields = luceneStorageConf.getFields();
        this.query = luceneStorageConf.getQuery();
        this.maxHits = luceneStorageConf.getMaxHits();
    }

    public Configuration serialize() throws IOException {
        DefaultStringifier.store((Configuration)this.configuration, (Object)this, (String)KEY);
        return new Configuration(this.configuration);
    }

    public Iterator<Pair<Text, Text>> getSequenceFileIterator() {
        return new SequenceFileDirIterable(this.sequenceFilesOutputPath, PathType.LIST, PathFilters.logsCRCFilter(), this.configuration).iterator();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Path getSequenceFilesOutputPath() {
        return this.sequenceFilesOutputPath;
    }

    public List<Path> getIndexPaths() {
        return this.indexPaths;
    }

    public String getIdField() {
        return this.idField;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public DocumentStoredFieldVisitor getStoredFieldVisitor() {
        HashSet fieldSet = Sets.newHashSet((Object[])new String[]{this.idField});
        fieldSet.addAll(this.fields);
        return new DocumentStoredFieldVisitor((Set)fieldSet);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.sequenceFilesOutputPath.toString());
        out.writeUTF(StringUtils.join(this.indexPaths, (String)","));
        out.writeUTF(this.idField);
        out.writeUTF(StringUtils.join(this.fields, (String)","));
        out.writeUTF(this.query.toString());
        out.writeInt(this.maxHits);
    }

    public void readFields(DataInput in) throws IOException {
        try {
            String[] indexPaths;
            this.sequenceFilesOutputPath = new Path(in.readUTF());
            this.indexPaths = Lists.newArrayList();
            for (String indexPath : indexPaths = in.readUTF().split(",")) {
                this.indexPaths.add(new Path(indexPath));
            }
            this.idField = in.readUTF();
            this.fields = Arrays.asList(in.readUTF().split(","));
            this.query = new QueryParser(Version.LUCENE_43, "query", (Analyzer)new StandardAnalyzer(Version.LUCENE_43)).parse(in.readUTF());
            this.maxHits = in.readInt();
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not deserialize " + this.getClass().getName(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneStorageConfiguration that = (LuceneStorageConfiguration)o;
        if (this.maxHits != that.maxHits) {
            return false;
        }
        if (this.fields != null ? !((Object)this.fields).equals(that.fields) : that.fields != null) {
            return false;
        }
        if (this.idField != null ? !this.idField.equals(that.idField) : that.idField != null) {
            return false;
        }
        if (this.indexPaths != null ? !((Object)this.indexPaths).equals(that.indexPaths) : that.indexPaths != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals((Object)that.query) : that.query != null) {
            return false;
        }
        return !(this.sequenceFilesOutputPath != null ? !this.sequenceFilesOutputPath.equals((Object)that.sequenceFilesOutputPath) : that.sequenceFilesOutputPath != null);
    }

    public int hashCode() {
        int result = this.indexPaths != null ? ((Object)this.indexPaths).hashCode() : 0;
        result = 31 * result + (this.sequenceFilesOutputPath != null ? this.sequenceFilesOutputPath.hashCode() : 0);
        result = 31 * result + (this.idField != null ? this.idField.hashCode() : 0);
        result = 31 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + this.maxHits;
        return result;
    }
}

