/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.utils.vectors.lucene.AbstractLuceneIterator;
import org.apache.mahout.vectorizer.Weight;

public class LuceneIterator
extends AbstractLuceneIterator {
    protected final Set<String> idFieldSelector;
    protected final String idField;

    public LuceneIterator(IndexReader indexReader, String idField, String field, TermInfo termInfo, Weight weight, double normPower) {
        this(indexReader, idField, field, termInfo, weight, normPower, 0.0);
    }

    public LuceneIterator(IndexReader indexReader, String idField, String field, TermInfo termInfo, Weight weight, double normPower, double maxPercentErrorDocs) {
        super(termInfo, normPower, indexReader, weight, maxPercentErrorDocs, field);
        Preconditions.checkArgument((normPower == -1.0 || normPower >= 0.0 ? 1 : 0) != 0, (Object)("normPower must be non-negative or -1, but normPower = " + normPower));
        Preconditions.checkArgument((maxPercentErrorDocs >= 0.0 && maxPercentErrorDocs <= 1.0 ? 1 : 0) != 0, (Object)"Must be: 0.0 <= maxPercentErrorDocs <= 1.0");
        this.idField = idField;
        if (idField != null) {
            this.idFieldSelector = new TreeSet<String>();
            this.idFieldSelector.add(idField);
        } else {
            this.idFieldSelector = null;
        }
    }

    @Override
    protected String getVectorName(int documentIndex) throws IOException {
        String name = this.idField != null ? this.indexReader.document(documentIndex, this.idFieldSelector).get(this.idField) : String.valueOf(documentIndex);
        return name;
    }
}

