/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.conversion;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class InputMapper
extends Mapper<LongWritable, Text, Text, VectorWritable> {
    private static final Pattern SPACE = Pattern.compile(" ");
    private Constructor<?> constructor;

    protected void map(LongWritable key, Text values, Mapper.Context context) throws IOException, InterruptedException {
        String[] numbers = SPACE.split(values.toString());
        ArrayList<Double> doubles = new ArrayList<Double>();
        for (String value : numbers) {
            if (value.isEmpty()) continue;
            doubles.add(Double.valueOf(value));
        }
        if (!doubles.isEmpty()) {
            try {
                Vector result = (Vector)this.constructor.newInstance(doubles.size());
                int index = 0;
                for (Double d : doubles) {
                    result.set(index++, d.doubleValue());
                }
                VectorWritable vectorWritable = new VectorWritable(result);
                context.write((Object)new Text(String.valueOf(index)), (Object)vectorWritable);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String vectorImplClassName = conf.get("vector.implementation.class.name");
        try {
            Class<Vector> outputClass = conf.getClassByName(vectorImplClassName).asSubclass(Vector.class);
            this.constructor = outputClass.getConstructor(Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

