/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.io.Charsets;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFIterator;
import org.apache.mahout.utils.vectors.arff.ARFFModel;
import org.apache.mahout.utils.vectors.arff.ARFFType;

public class ARFFVectorIterable
implements Iterable<Vector> {
    private final BufferedReader buff;
    private final ARFFModel model;

    public ARFFVectorIterable(File file, ARFFModel model) throws IOException {
        this(file, Charsets.UTF_8, model);
    }

    public ARFFVectorIterable(File file, Charset encoding, ARFFModel model) throws IOException {
        this(Files.newReader((File)file, (Charset)encoding), model);
    }

    public ARFFVectorIterable(String arff, ARFFModel model) throws IOException {
        this(new StringReader(arff), model);
    }

    public ARFFVectorIterable(Reader reader, ARFFModel model) throws IOException {
        String line;
        this.buff = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.model = model;
        int labelNumber = 0;
        while ((line = this.buff.readLine()) != null) {
            if ((line = line.trim()).startsWith("%") || line.isEmpty()) continue;
            Integer labelNumInt = labelNumber;
            String[] lineParts = line.split("[\\s\\t]+", 2);
            if (lineParts[0].equalsIgnoreCase("@relation")) {
                model.setRelation(ARFFType.removeQuotes(lineParts[1]));
                continue;
            }
            if (lineParts[0].equalsIgnoreCase("@attribute")) {
                ARFFType type;
                String[] attrParts = lineParts[1].split("[\\s\\t]+", 2);
                if (attrParts.length < 2) {
                    throw new UnsupportedOperationException("No type for attribute found: " + lineParts[1]);
                }
                String label = ARFFType.removeQuotes(attrParts[0].toLowerCase());
                if (attrParts[1].equalsIgnoreCase(ARFFType.NUMERIC.getIndicator())) {
                    type = ARFFType.NUMERIC;
                } else if (attrParts[1].equalsIgnoreCase(ARFFType.INTEGER.getIndicator())) {
                    type = ARFFType.INTEGER;
                } else if (attrParts[1].equalsIgnoreCase(ARFFType.REAL.getIndicator())) {
                    type = ARFFType.REAL;
                } else if (attrParts[1].equalsIgnoreCase(ARFFType.STRING.getIndicator())) {
                    type = ARFFType.STRING;
                } else if (attrParts[1].toLowerCase().startsWith(ARFFType.NOMINAL.getIndicator())) {
                    type = ARFFType.NOMINAL;
                    String[] classes = ARFFIterator.splitCSV(attrParts[1].substring(1, attrParts[1].length() - 1));
                    for (int i = 0; i < classes.length; ++i) {
                        model.addNominal(label, ARFFType.removeQuotes(classes[i]), i + 1);
                    }
                } else if (attrParts[1].toLowerCase().startsWith(ARFFType.DATE.getIndicator())) {
                    type = ARFFType.DATE;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                    String formStr = attrParts[1].substring(ARFFType.DATE.getIndicator().length()).trim();
                    if (!formStr.isEmpty()) {
                        if (formStr.startsWith("\"")) {
                            formStr = formStr.substring(1, formStr.length() - 1);
                        }
                        format = new SimpleDateFormat(formStr, Locale.ENGLISH);
                    }
                    model.addDateFormat(labelNumInt, format);
                } else {
                    throw new UnsupportedOperationException("Invalid attribute: " + attrParts[1]);
                }
                model.addLabel(label, labelNumInt);
                model.addType(labelNumInt, type);
                ++labelNumber;
                continue;
            }
            if (!lineParts[0].equalsIgnoreCase("@data")) continue;
            break;
        }
    }

    @Override
    public Iterator<Vector> iterator() {
        return new ARFFIterator(this.buff, this.model);
    }

    public ARFFModel getModel() {
        return this.model;
    }
}

