/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.regex;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.lucene.TokenStreamIterator;
import org.apache.mahout.utils.regex.RegexTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerTransformer
implements RegexTransformer {
    private Analyzer analyzer;
    private String fieldName = "text";
    private static final Logger log = LoggerFactory.getLogger(AnalyzerTransformer.class);

    public AnalyzerTransformer() {
        this((Analyzer)new StandardAnalyzer(Version.LUCENE_46), "text");
    }

    public AnalyzerTransformer(Analyzer analyzer) {
        this(analyzer, "text");
    }

    public AnalyzerTransformer(Analyzer analyzer, String fieldName) {
        this.analyzer = analyzer;
        this.fieldName = fieldName;
    }

    @Override
    public String transformMatch(String match) {
        StringBuilder result = new StringBuilder();
        try (TokenStream ts = this.analyzer.tokenStream(this.fieldName, (Reader)new StringReader(match));){
            ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            TokenStreamIterator iter = new TokenStreamIterator(ts);
            while (iter.hasNext()) {
                result.append((String)iter.next()).append(' ');
            }
            ts.end();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result.toString();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }
}

