/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.mahout.text.PrefixAdditionFilter;
import org.apache.mahout.text.SequenceFilesFromDirectory;

public class WholeFileRecordReader
extends RecordReader<IntWritable, BytesWritable> {
    private FileSplit fileSplit;
    private boolean processed = false;
    private Configuration configuration;
    private BytesWritable value = new BytesWritable();
    private IntWritable index;
    private String fileFilterClassName = null;
    private PathFilter pathFilter = null;

    public WholeFileRecordReader(CombineFileSplit fileSplit, TaskAttemptContext taskAttemptContext, Integer idx) throws IOException {
        this.fileSplit = new FileSplit(fileSplit.getPath(idx.intValue()), fileSplit.getOffset(idx.intValue()), fileSplit.getLength(idx.intValue()), fileSplit.getLocations());
        this.configuration = taskAttemptContext.getConfiguration();
        this.index = new IntWritable(idx.intValue());
        this.fileFilterClassName = this.configuration.get(SequenceFilesFromDirectory.FILE_FILTER_CLASS_OPTION[0]);
    }

    public IntWritable getCurrentKey() {
        return this.index;
    }

    public BytesWritable getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException {
        return this.processed ? 1.0f : 0.0f;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (!StringUtils.isBlank((CharSequence)this.fileFilterClassName) && !PrefixAdditionFilter.class.getName().equals(this.fileFilterClassName)) {
            try {
                this.pathFilter = (PathFilter)Class.forName(this.fileFilterClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.processed) {
            byte[] contents = new byte[(int)this.fileSplit.getLength()];
            Path file = this.fileSplit.getPath();
            FileSystem fs = file.getFileSystem(this.configuration);
            if (!fs.isFile(file)) {
                return false;
            }
            FileStatus[] fileStatuses = this.pathFilter != null ? fs.listStatus(file, this.pathFilter) : fs.listStatus(file);
            if (fileStatuses.length == 1) {
                try (FSDataInputStream in = fs.open(fileStatuses[0].getPath());){
                    IOUtils.readFully((InputStream)in, (byte[])contents, (int)0, (int)contents.length);
                    this.value.setCapacity(contents.length);
                    this.value.set(contents, 0, contents.length);
                }
                this.processed = true;
                return true;
            }
        }
        return false;
    }

    public void close() throws IOException {
    }
}

