/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ClusterEvaluator.class);
    private final Map<Integer, List<VectorWritable>> representativePoints;
    private final List<Cluster> clusters;
    private final DistanceMeasure measure;

    public ClusterEvaluator(Map<Integer, List<VectorWritable>> representativePoints, List<Cluster> clusters, DistanceMeasure measure) {
        this.representativePoints = representativePoints;
        this.clusters = clusters;
        this.measure = measure;
    }

    public ClusterEvaluator(Configuration conf, Path clustersIn) {
        this.measure = (DistanceMeasure)ClassUtils.instantiateAs((String)conf.get("org.apache.mahout.clustering.measure"), DistanceMeasure.class);
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
        this.clusters = ClusterEvaluator.loadClusters(conf, clustersIn);
    }

    private static List<Cluster> loadClusters(Configuration conf, Path clustersIn) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (ClusterWritable clusterWritable : new SequenceFileDirValueIterable(clustersIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            Cluster cluster = clusterWritable.getValue();
            clusters.add(cluster);
        }
        return clusters;
    }

    public double interClusterDensity() {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        double sum = 0.0;
        int count = 0;
        Map<Integer, Vector> distances = this.interClusterDistances();
        for (Vector row : distances.values()) {
            for (Vector.Element element : row.nonZeroes()) {
                double d = element.get();
                min = Math.min(d, min);
                max = Math.max(d, max);
                sum += d;
                ++count;
            }
        }
        double density = (sum / (double)count - min) / (max - min);
        log.info("Scaled Inter-Cluster Density = {}", (Object)density);
        return density;
    }

    public Map<Integer, Vector> interClusterDistances() {
        TreeMap<Integer, Vector> distances = new TreeMap<Integer, Vector>();
        for (int i = 0; i < this.clusters.size(); ++i) {
            Cluster clusterI = this.clusters.get(i);
            RandomAccessSparseVector row = new RandomAccessSparseVector(Integer.MAX_VALUE);
            distances.put(clusterI.getId(), (Vector)row);
            for (int j = i + 1; j < this.clusters.size(); ++j) {
                Cluster clusterJ = this.clusters.get(j);
                double d = this.measure.distance(clusterI.getCenter(), clusterJ.getCenter());
                row.set(clusterJ.getId(), d);
            }
        }
        return distances;
    }

    public double intraClusterDensity() {
        double avgDensity = 0.0;
        int count = 0;
        for (Vector.Element elem : this.intraClusterDensities().nonZeroes()) {
            double value = elem.get();
            if (Double.isNaN(value)) continue;
            avgDensity += value;
            ++count;
        }
        avgDensity = this.clusters.isEmpty() ? 0.0 : avgDensity / (double)count;
        log.info("Average Intra-Cluster Density = {}", (Object)avgDensity);
        return avgDensity;
    }

    public Vector intraClusterDensities() {
        RandomAccessSparseVector densities = new RandomAccessSparseVector(Integer.MAX_VALUE);
        for (Cluster cluster : this.clusters) {
            int count = 0;
            double max = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            double sum = 0.0;
            List<VectorWritable> repPoints = this.representativePoints.get(cluster.getId());
            for (int i = 0; i < repPoints.size(); ++i) {
                for (int j = i + 1; j < repPoints.size(); ++j) {
                    Vector v1 = repPoints.get(i).get();
                    Vector v2 = repPoints.get(j).get();
                    double d = this.measure.distance(v1, v2);
                    min = Math.min(d, min);
                    max = Math.max(d, max);
                    sum += d;
                    ++count;
                }
            }
            double density = (sum / (double)count - min) / (max - min);
            densities.set(cluster.getId(), density);
            log.info("Intra-Cluster Density[{}] = {}", (Object)cluster.getId(), (Object)density);
        }
        return densities;
    }
}

