/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public final class VectorWritableTest
extends RandomizedTest {
    private static final int MAX_VECTOR_SIZE = 100;

    public void createRandom(Vector v) {
        int size = VectorWritableTest.randomInt((int)(v.size() - 1));
        for (int i = 0; i < size; ++i) {
            v.set(VectorWritableTest.randomInt((int)(v.size() - 1)), VectorWritableTest.randomDouble());
        }
        int zeros = Math.max(2, size / 4);
        for (Vector.Element e : v.nonZeroes()) {
            if (e.index() % zeros != 0) continue;
            e.set(0.0);
        }
    }

    @Test
    @Repeat(iterations=20)
    public void testViewSequentialAccessSparseVectorWritable() throws Exception {
        SequentialAccessSparseVector v = new SequentialAccessSparseVector(100);
        this.createRandom((Vector)v);
        VectorView view = new VectorView((Vector)v, 0, v.size());
        VectorWritableTest.doTestVectorWritableEquals((Vector)view);
    }

    @Test
    @Repeat(iterations=20)
    public void testSequentialAccessSparseVectorWritable() throws Exception {
        SequentialAccessSparseVector v = new SequentialAccessSparseVector(100);
        this.createRandom((Vector)v);
        VectorWritableTest.doTestVectorWritableEquals((Vector)v);
    }

    @Test
    @Repeat(iterations=20)
    public void testRandomAccessSparseVectorWritable() throws Exception {
        RandomAccessSparseVector v = new RandomAccessSparseVector(100);
        this.createRandom((Vector)v);
        VectorWritableTest.doTestVectorWritableEquals((Vector)v);
    }

    @Test
    @Repeat(iterations=20)
    public void testDenseVectorWritable() throws Exception {
        DenseVector v = new DenseVector(100);
        this.createRandom((Vector)v);
        VectorWritableTest.doTestVectorWritableEquals((Vector)v);
    }

    @Test
    @Repeat(iterations=20)
    public void testNamedVectorWritable() throws Exception {
        DenseVector v = new DenseVector(100);
        v = new NamedVector((Vector)v, "Victor");
        this.createRandom((Vector)v);
        VectorWritableTest.doTestVectorWritableEquals((Vector)v);
    }

    private static void doTestVectorWritableEquals(Vector v) throws IOException {
        VectorWritable vectorWritable = new VectorWritable(v);
        VectorWritable vectorWritable2 = new VectorWritable();
        VectorWritableTest.writeAndRead((Writable)vectorWritable, (Writable)vectorWritable2);
        Vector v2 = vectorWritable2.get();
        if (v instanceof NamedVector) {
            VectorWritableTest.assertTrue((boolean)(v2 instanceof NamedVector));
            NamedVector nv = (NamedVector)v;
            NamedVector nv2 = (NamedVector)v2;
            VectorWritableTest.assertEquals((Object)nv.getName(), (Object)nv2.getName());
            VectorWritableTest.assertEquals((Object)"Victor", (Object)nv.getName());
        }
        VectorWritableTest.assertEquals((Object)v, (Object)v2);
    }

    private static void writeAndRead(Writable toWrite, Writable toRead) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            toWrite.write((DataOutput)dos);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (DataInputStream dis = new DataInputStream(bais);){
            toRead.readFields((DataInput)dis);
        }
    }
}

