/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Varint;
import org.junit.Test;

public final class VarintTest
extends MahoutTestCase {
    @Test
    public void testUnsignedLong() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        Varint.writeUnsignedVarLong((long)0L, (DataOutput)out);
        for (long i = 1L; i > 0L && i <= 0x4000000000000000L; i <<= 1) {
            Varint.writeUnsignedVarLong((long)(i - 1L), (DataOutput)out);
            Varint.writeUnsignedVarLong((long)i, (DataOutput)out);
        }
        Varint.writeUnsignedVarLong((long)Long.MAX_VALUE, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        VarintTest.assertEquals((long)0L, (long)Varint.readUnsignedVarLong((DataInput)in));
        for (long i = 1L; i > 0L && i <= 0x4000000000000000L; i <<= 1) {
            VarintTest.assertEquals((long)(i - 1L), (long)Varint.readUnsignedVarLong((DataInput)in));
            VarintTest.assertEquals((long)i, (long)Varint.readUnsignedVarLong((DataInput)in));
        }
        VarintTest.assertEquals((long)Long.MAX_VALUE, (long)Varint.readUnsignedVarLong((DataInput)in));
    }

    @Test
    public void testSignedPositiveLong() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        Varint.writeSignedVarLong((long)0L, (DataOutput)out);
        for (long i = 1L; i <= 0x2000000000000000L; i <<= 1) {
            Varint.writeSignedVarLong((long)(i - 1L), (DataOutput)out);
            Varint.writeSignedVarLong((long)i, (DataOutput)out);
        }
        Varint.writeSignedVarLong((long)0x3FFFFFFFFFFFFFFFL, (DataOutput)out);
        Varint.writeSignedVarLong((long)0x4000000000000000L, (DataOutput)out);
        Varint.writeSignedVarLong((long)Long.MAX_VALUE, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        VarintTest.assertEquals((long)0L, (long)Varint.readSignedVarLong((DataInput)in));
        for (long i = 1L; i <= 0x2000000000000000L; i <<= 1) {
            VarintTest.assertEquals((long)(i - 1L), (long)Varint.readSignedVarLong((DataInput)in));
            VarintTest.assertEquals((long)i, (long)Varint.readSignedVarLong((DataInput)in));
        }
        VarintTest.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)Varint.readSignedVarLong((DataInput)in));
        VarintTest.assertEquals((long)0x4000000000000000L, (long)Varint.readSignedVarLong((DataInput)in));
        VarintTest.assertEquals((long)Long.MAX_VALUE, (long)Varint.readSignedVarLong((DataInput)in));
    }

    @Test
    public void testSignedNegativeLong() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (long i = -1L; i >= -4611686018427387904L; i <<= 1) {
            Varint.writeSignedVarLong((long)i, (DataOutput)out);
            Varint.writeSignedVarLong((long)(i + 1L), (DataOutput)out);
        }
        Varint.writeSignedVarLong((long)Long.MIN_VALUE, (DataOutput)out);
        Varint.writeSignedVarLong((long)-9223372036854775807L, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        for (long i = -1L; i >= -4611686018427387904L; i <<= 1) {
            VarintTest.assertEquals((long)i, (long)Varint.readSignedVarLong((DataInput)in));
            VarintTest.assertEquals((long)(i + 1L), (long)Varint.readSignedVarLong((DataInput)in));
        }
        VarintTest.assertEquals((long)Long.MIN_VALUE, (long)Varint.readSignedVarLong((DataInput)in));
        VarintTest.assertEquals((long)-9223372036854775807L, (long)Varint.readSignedVarLong((DataInput)in));
    }

    @Test
    public void testUnsignedInt() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        Varint.writeUnsignedVarInt((int)0, (DataOutput)out);
        for (int i = 1; i > 0 && i <= 0x40000000; i <<= 1) {
            Varint.writeUnsignedVarLong((long)(i - 1), (DataOutput)out);
            Varint.writeUnsignedVarLong((long)i, (DataOutput)out);
        }
        Varint.writeUnsignedVarLong((long)Integer.MAX_VALUE, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        VarintTest.assertEquals((long)0L, (long)Varint.readUnsignedVarInt((DataInput)in));
        for (int i = 1; i > 0 && i <= 0x40000000; i <<= 1) {
            VarintTest.assertEquals((long)(i - 1), (long)Varint.readUnsignedVarInt((DataInput)in));
            VarintTest.assertEquals((long)i, (long)Varint.readUnsignedVarInt((DataInput)in));
        }
        VarintTest.assertEquals((long)Integer.MAX_VALUE, (long)Varint.readUnsignedVarInt((DataInput)in));
    }

    @Test
    public void testSignedPositiveInt() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        Varint.writeSignedVarInt((int)0, (DataOutput)out);
        for (int i = 1; i <= 0x20000000; i <<= 1) {
            Varint.writeSignedVarLong((long)(i - 1), (DataOutput)out);
            Varint.writeSignedVarLong((long)i, (DataOutput)out);
        }
        Varint.writeSignedVarInt((int)0x3FFFFFFF, (DataOutput)out);
        Varint.writeSignedVarInt((int)0x40000000, (DataOutput)out);
        Varint.writeSignedVarInt((int)Integer.MAX_VALUE, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        VarintTest.assertEquals((long)0L, (long)Varint.readSignedVarInt((DataInput)in));
        for (int i = 1; i <= 0x20000000; i <<= 1) {
            VarintTest.assertEquals((long)(i - 1), (long)Varint.readSignedVarInt((DataInput)in));
            VarintTest.assertEquals((long)i, (long)Varint.readSignedVarInt((DataInput)in));
        }
        VarintTest.assertEquals((long)0x3FFFFFFFL, (long)Varint.readSignedVarInt((DataInput)in));
        VarintTest.assertEquals((long)0x40000000L, (long)Varint.readSignedVarInt((DataInput)in));
        VarintTest.assertEquals((long)Integer.MAX_VALUE, (long)Varint.readSignedVarInt((DataInput)in));
    }

    @Test
    public void testSignedNegativeInt() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (int i = -1; i >= -1073741824; i <<= 1) {
            Varint.writeSignedVarInt((int)i, (DataOutput)out);
            Varint.writeSignedVarInt((int)(i + 1), (DataOutput)out);
        }
        Varint.writeSignedVarInt((int)Integer.MIN_VALUE, (DataOutput)out);
        Varint.writeSignedVarInt((int)-2147483647, (DataOutput)out);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        for (int i = -1; i >= -1073741824; i <<= 1) {
            VarintTest.assertEquals((long)i, (long)Varint.readSignedVarInt((DataInput)in));
            VarintTest.assertEquals((long)(i + 1), (long)Varint.readSignedVarInt((DataInput)in));
        }
        VarintTest.assertEquals((long)Integer.MIN_VALUE, (long)Varint.readSignedVarInt((DataInput)in));
        VarintTest.assertEquals((long)-2147483647L, (long)Varint.readSignedVarInt((DataInput)in));
    }

    @Test
    public void testUnsignedSize() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        int expectedSize = 0;
        for (int exponent = 0; exponent <= 62; ++exponent) {
            Varint.writeUnsignedVarLong((long)(1L << exponent), (DataOutput)out);
            VarintTest.assertEquals((long)(expectedSize += 1 + exponent / 7), (long)baos.size());
        }
    }

    @Test
    public void testSignedSize() throws Exception {
        int exponent;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        int expectedSize = 0;
        for (exponent = 0; exponent <= 61; ++exponent) {
            Varint.writeSignedVarLong((long)(1L << exponent), (DataOutput)out);
            VarintTest.assertEquals((long)(expectedSize += 1 + (exponent + 1) / 7), (long)baos.size());
        }
        for (exponent = 0; exponent <= 61; ++exponent) {
            Varint.writeSignedVarLong((long)(-(1L << exponent) - 1L), (DataOutput)out);
            VarintTest.assertEquals((long)(expectedSize += 1 + (exponent + 1) / 7), (long)baos.size());
        }
    }
}

