/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.junit.Test;

public final class MatrixWritableTest
extends MahoutTestCase {
    @Test
    public void testSparseMatrixWritable() throws Exception {
        SparseMatrix m = new SparseMatrix(5, 5);
        m.set(1, 2, 3.0);
        m.set(3, 4, 5.0);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("A", 0);
        bindings.put("B", 1);
        bindings.put("C", 2);
        bindings.put("D", 3);
        bindings.put("default", 4);
        m.setRowLabelBindings(bindings);
        m.setColumnLabelBindings(bindings);
        MatrixWritableTest.doTestMatrixWritableEquals((Matrix)m);
    }

    @Test
    public void testSparseRowMatrixWritable() throws Exception {
        SparseRowMatrix m = new SparseRowMatrix(5, 5);
        m.set(1, 2, 3.0);
        m.set(3, 4, 5.0);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("A", 0);
        bindings.put("B", 1);
        bindings.put("C", 2);
        bindings.put("D", 3);
        bindings.put("default", 4);
        m.setRowLabelBindings(bindings);
        m.setColumnLabelBindings(bindings);
        MatrixWritableTest.doTestMatrixWritableEquals((Matrix)m);
    }

    @Test
    public void testDenseMatrixWritable() throws Exception {
        DenseMatrix m = new DenseMatrix(5, 5);
        m.set(1, 2, 3.0);
        m.set(3, 4, 5.0);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("A", 0);
        bindings.put("B", 1);
        bindings.put("C", 2);
        bindings.put("D", 3);
        bindings.put("default", 4);
        m.setRowLabelBindings(bindings);
        m.setColumnLabelBindings(bindings);
        MatrixWritableTest.doTestMatrixWritableEquals((Matrix)m);
    }

    private static void doTestMatrixWritableEquals(Matrix m) throws IOException {
        MatrixWritable matrixWritable = new MatrixWritable(m);
        MatrixWritable matrixWritable2 = new MatrixWritable();
        MatrixWritableTest.writeAndRead((Writable)matrixWritable, (Writable)matrixWritable2);
        Matrix m2 = matrixWritable2.get();
        MatrixWritableTest.compareMatrices(m, m2);
        MatrixWritableTest.doCheckBindings(m2.getRowLabelBindings());
        MatrixWritableTest.doCheckBindings(m2.getColumnLabelBindings());
    }

    private static void compareMatrices(Matrix m, Matrix m2) {
        MatrixWritableTest.assertEquals((long)m.numRows(), (long)m2.numRows());
        MatrixWritableTest.assertEquals((long)m.numCols(), (long)m2.numCols());
        for (int r = 0; r < m.numRows(); ++r) {
            for (int c = 0; c < m.numCols(); ++c) {
                MatrixWritableTest.assertEquals((double)m.get(r, c), (double)m2.get(r, c), (double)1.0E-6);
            }
        }
        Map bindings = m.getRowLabelBindings();
        Map bindings2 = m2.getRowLabelBindings();
        MatrixWritableTest.assertEquals((Object)(bindings == null ? 1 : 0), (Object)(bindings2 == null ? 1 : 0));
        if (bindings != null) {
            MatrixWritableTest.assertEquals((long)bindings.size(), (long)m.numRows());
            MatrixWritableTest.assertEquals((long)bindings.size(), (long)bindings2.size());
            for (Map.Entry entry : bindings.entrySet()) {
                MatrixWritableTest.assertEquals(entry.getValue(), bindings2.get(entry.getKey()));
            }
        }
        bindings = m.getColumnLabelBindings();
        bindings2 = m2.getColumnLabelBindings();
        MatrixWritableTest.assertEquals((Object)(bindings == null ? 1 : 0), (Object)(bindings2 == null ? 1 : 0));
        if (bindings != null) {
            MatrixWritableTest.assertEquals((long)bindings.size(), (long)bindings2.size());
            for (Map.Entry entry : bindings.entrySet()) {
                MatrixWritableTest.assertEquals(entry.getValue(), bindings2.get(entry.getKey()));
            }
        }
    }

    private static void doCheckBindings(Map<String, Integer> labels) {
        MatrixWritableTest.assertTrue((String)"Missing label", (boolean)labels.keySet().contains("A"));
        MatrixWritableTest.assertTrue((String)"Missing label", (boolean)labels.keySet().contains("B"));
        MatrixWritableTest.assertTrue((String)"Missing label", (boolean)labels.keySet().contains("C"));
        MatrixWritableTest.assertTrue((String)"Missing label", (boolean)labels.keySet().contains("D"));
        MatrixWritableTest.assertTrue((String)"Missing label", (boolean)labels.keySet().contains("default"));
    }

    private static void writeAndRead(Writable toWrite, Writable toRead) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            toWrite.write((DataOutput)dos);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (DataInputStream dis = new DataInputStream(bais);){
            toRead.readFields((DataInput)dis);
        }
    }
}

