/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.compression.lzma.LZMADecoder;
import org.glassfish.grizzly.compression.lzma.LZMAEncoder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.ParsingResult;

public class LZMAContentEncoding
implements ContentEncoding {
    public static final String[] ALIASES = new String[]{"lzma"};
    private static final String NAME = "lzma";
    private final LZMADecoder decoder = new LZMADecoder();
    private final LZMAEncoder encoder = new LZMAEncoder();
    private final EncodingFilter encodingFilter;

    public LZMAContentEncoding() {
        this(null);
    }

    public LZMAContentEncoding(EncodingFilter encodingFilter) {
        this.encodingFilter = encodingFilter != null ? encodingFilter : new EncodingFilter(){

            @Override
            public boolean applyEncoding(HttpHeader httpPacket) {
                return false;
            }

            @Override
            public boolean applyDecoding(HttpHeader httpPacket) {
                return true;
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public boolean wantDecode(HttpHeader header) {
        return this.encodingFilter.applyDecoding(header);
    }

    @Override
    public boolean wantEncode(HttpHeader header) {
        return this.encodingFilter.applyEncoding(header);
    }

    @Override
    public ParsingResult decode(Connection connection, HttpContent httpContent) {
        Buffer input;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        TransformationResult result = this.decoder.transform(httpHeader, input = httpContent.getContent());
        Buffer remainder = result.getExternalRemainder();
        if (remainder == null || !remainder.hasRemaining()) {
            input.tryDispose();
            remainder = null;
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    httpContent.setContent((Buffer)result.getMessage());
                    this.decoder.finish(httpHeader);
                    ParsingResult parsingResult = ParsingResult.create(httpContent, remainder);
                    return parsingResult;
                }
                case INCOMPLETE: {
                    ParsingResult parsingResult = ParsingResult.create(null, remainder);
                    return parsingResult;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public HttpContent encode(Connection connection, HttpContent httpContent) {
        HttpHeader httpHeader = httpContent.getHttpHeader();
        Buffer input = httpContent.getContent();
        if (httpContent.isLast() && !input.hasRemaining()) {
            return httpContent;
        }
        TransformationResult result = this.encoder.transform(httpContent.getHttpHeader(), input);
        input.tryDispose();
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    this.encoder.finish(httpHeader);
                }
                case INCOMPLETE: {
                    Buffer encodedBuffer = (Buffer)result.getMessage();
                    if (encodedBuffer != null) {
                        httpContent.setContent(encodedBuffer);
                        HttpContent httpContent2 = httpContent;
                        return httpContent2;
                    }
                    HttpContent httpContent3 = null;
                    return httpContent3;
                }
                case ERROR: {
                    throw new IllegalStateException("LZMA encode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getStatus()));
        }
        finally {
            result.recycle();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LZMAContentEncoding that = (LZMAContentEncoding)o;
        if (this.decoder != null ? !this.decoder.equals(that.decoder) : that.decoder != null) {
            return false;
        }
        if (this.encoder != null ? !this.encoder.equals(that.encoder) : that.encoder != null) {
            return false;
        }
        return !(this.encodingFilter != null ? !this.encodingFilter.equals(that.encodingFilter) : that.encodingFilter != null);
    }

    public int hashCode() {
        int result = this.decoder != null ? this.decoder.hashCode() : 0;
        result = 31 * result + (this.encoder != null ? this.encoder.hashCode() : 0);
        result = 31 * result + (this.encodingFilter != null ? this.encodingFilter.hashCode() : 0);
        return result;
    }
}

