/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.term;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class TermCountReducer
extends Reducer<Text, LongWritable, Text, LongWritable> {
    private int minSupport;

    @Override
    protected void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        long sum = 0L;
        for (LongWritable value : values) {
            sum += value.get();
        }
        if (sum >= (long)this.minSupport) {
            context.write(key, new LongWritable(sum));
        }
    }

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.minSupport = context.getConfiguration().getInt("min.support", 2);
    }
}

