/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.document;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.StringReader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.lucene.AnalyzerUtils;

public class SequenceFileTokenizerMapper
extends Mapper<Text, Text, Text, StringTuple> {
    private Analyzer analyzer;

    @Override
    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        TokenStream stream = this.analyzer.tokenStream(key.toString(), new StringReader(value.toString()));
        CharTermAttribute termAtt = stream.addAttribute(CharTermAttribute.class);
        stream.reset();
        StringTuple document = new StringTuple();
        while (stream.incrementToken()) {
            if (termAtt.length() <= 0) continue;
            document.add(new String(termAtt.buffer(), 0, termAtt.length()));
        }
        stream.end();
        Closeables.close(stream, true);
        context.write(key, document);
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String analyzerClassName = context.getConfiguration().get("analyzer.class", StandardAnalyzer.class.getName());
        try {
            this.analyzer = AnalyzerUtils.createAnalyzer(analyzerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to create analyzer: " + analyzerClassName, e);
        }
    }
}

