/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.stats.LogLikelihood;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLRReducer
extends Reducer<Gram, Gram, Text, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(LLRReducer.class);
    public static final String NGRAM_TOTAL = "ngramTotal";
    public static final String MIN_LLR = "minLLR";
    public static final float DEFAULT_MIN_LLR = 1.0f;
    private long ngramTotal;
    private float minLLRValue;
    private boolean emitUnigrams;
    private final LLCallback ll;

    @Override
    protected void reduce(Gram ngram, Iterable<Gram> values, Reducer.Context context) throws IOException, InterruptedException {
        double llr;
        int[] gramFreq = new int[]{-1, -1};
        if (ngram.getType() == Gram.Type.UNIGRAM && this.emitUnigrams) {
            DoubleWritable dd = new DoubleWritable(ngram.getFrequency());
            Text t = new Text(ngram.getString());
            context.write(t, dd);
            return;
        }
        String[] gram = new String[2];
        for (Gram value : values) {
            int pos;
            int n = pos = value.getType() == Gram.Type.HEAD ? 0 : 1;
            if (gramFreq[pos] != -1) {
                log.warn("Extra {} for {}, skipping", (Object)value.getType(), (Object)ngram);
                if (value.getType() == Gram.Type.HEAD) {
                    context.getCounter(Skipped.EXTRA_HEAD).increment(1L);
                } else {
                    context.getCounter(Skipped.EXTRA_TAIL).increment(1L);
                }
                return;
            }
            gram[pos] = value.getString();
            gramFreq[pos] = value.getFrequency();
        }
        if (gramFreq[0] == -1) {
            log.warn("Missing head for {}, skipping.", (Object)ngram);
            context.getCounter(Skipped.MISSING_HEAD).increment(1L);
            return;
        }
        if (gramFreq[1] == -1) {
            log.warn("Missing tail for {}, skipping", (Object)ngram);
            context.getCounter(Skipped.MISSING_TAIL).increment(1L);
            return;
        }
        long k11 = ngram.getFrequency();
        long k12 = gramFreq[0] - ngram.getFrequency();
        long k21 = gramFreq[1] - ngram.getFrequency();
        long k22 = this.ngramTotal - (long)(gramFreq[0] + gramFreq[1] - ngram.getFrequency());
        try {
            llr = this.ll.logLikelihoodRatio(k11, k12, k21, k22);
        }
        catch (IllegalArgumentException ex) {
            context.getCounter(Skipped.LLR_CALCULATION_ERROR).increment(1L);
            log.warn("Problem calculating LLR ratio for ngram {}, HEAD {}:{}, TAIL {}:{}, k11/k12/k21/k22: {}/{}/{}/{}", new Object[]{ngram, gram[0], gramFreq[0], gram[1], gramFreq[1], k11, k12, k21, k22, ex});
            return;
        }
        if (llr < (double)this.minLLRValue) {
            context.getCounter(Skipped.LESS_THAN_MIN_LLR).increment(1L);
        } else {
            context.write(new Text(ngram.getString()), new DoubleWritable(llr));
        }
    }

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.ngramTotal = conf.getLong(NGRAM_TOTAL, -1L);
        this.minLLRValue = conf.getFloat(MIN_LLR, 1.0f);
        this.emitUnigrams = conf.getBoolean("emit-unigrams", false);
        log.info("NGram Total: {}, Min LLR value: {}, Emit Unigrams: {}", new Object[]{this.ngramTotal, Float.valueOf(this.minLLRValue), this.emitUnigrams});
        if (this.ngramTotal == -1L) {
            throw new IllegalStateException("No NGRAM_TOTAL available in job config");
        }
    }

    public LLRReducer() {
        this.ll = new ConcreteLLCallback();
    }

    LLRReducer(LLCallback ll) {
        this.ll = ll;
    }

    public static final class ConcreteLLCallback
    implements LLCallback {
        @Override
        public double logLikelihoodRatio(long k11, long k12, long k21, long k22) {
            return LogLikelihood.logLikelihoodRatio(k11, k12, k21, k22);
        }
    }

    public static interface LLCallback {
        public double logLikelihoodRatio(long var1, long var3, long var5, long var7);
    }

    public static enum Skipped {
        EXTRA_HEAD,
        EXTRA_TAIL,
        MISSING_HEAD,
        MISSING_TAIL,
        LESS_THAN_MIN_LLR,
        LLR_CALCULATION_ERROR;

    }
}

