/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.vectorizer.collocations.llr.Gram;

public final class GramKey
extends BinaryComparable
implements WritableComparable<BinaryComparable> {
    private int primaryLength;
    private int length;
    private byte[] bytes;

    public GramKey() {
    }

    public GramKey(Gram gram, byte[] order) {
        this.set(gram, order);
    }

    public void set(Gram gram, byte[] order) {
        this.primaryLength = gram.getLength();
        this.length = this.primaryLength + order.length;
        this.setCapacity(this.length, false);
        System.arraycopy(gram.getBytes(), 0, this.bytes, 0, this.primaryLength);
        if (order.length > 0) {
            System.arraycopy(order, 0, this.bytes, this.primaryLength, order.length);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public int getPrimaryLength() {
        return this.primaryLength;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int newLength = Varint.readUnsignedVarInt(in);
        int newPrimaryLength = Varint.readUnsignedVarInt(in);
        this.setCapacity(newLength, false);
        in.readFully(this.bytes, 0, newLength);
        this.length = newLength;
        this.primaryLength = newPrimaryLength;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(this.length, out);
        Varint.writeUnsignedVarInt(this.primaryLength, out);
        out.write(this.bytes, 0, this.length);
    }

    private void setCapacity(int len, boolean keepData) {
        if (this.bytes == null || this.bytes.length < len) {
            byte[] newBytes = new byte[len];
            if (this.bytes != null && keepData) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            }
            this.bytes = newBytes;
        }
    }

    public Gram.Type getType() {
        return Gram.decodeType(this.bytes, 0);
    }

    public String getPrimaryString() {
        try {
            return Text.decode(this.bytes, 1, this.primaryLength - 1);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return '\'' + this.getPrimaryString() + "'[" + (Object)((Object)this.getType()) + ']';
    }
}

