/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.io;

import com.google.common.io.Closeables;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.io.VectorWriter;

public class SequenceFileVectorWriter
implements VectorWriter {
    private final SequenceFile.Writer writer;
    private long recNum = 0L;

    public SequenceFileVectorWriter(SequenceFile.Writer writer) {
        this.writer = writer;
    }

    @Override
    public long write(Iterable<Vector> iterable, long maxDocs) throws IOException {
        for (Vector point : iterable) {
            if (this.recNum >= maxDocs) break;
            if (point == null) continue;
            this.writer.append(new LongWritable(this.recNum++), new VectorWritable(point));
        }
        return this.recNum;
    }

    @Override
    public void write(Vector vector) throws IOException {
        this.writer.append(new LongWritable(this.recNum++), new VectorWritable(vector));
    }

    @Override
    public long write(Iterable<Vector> iterable) throws IOException {
        return this.write(iterable, Long.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.writer, false);
    }

    public SequenceFile.Writer getWriter() {
        return this.writer;
    }
}

