/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text.wikipedia;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.Version;

public class WikipediaAnalyzer
extends StopwordAnalyzerBase {
    public WikipediaAnalyzer() {
        super(Version.LUCENE_46, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    public WikipediaAnalyzer(CharArraySet stopSet) {
        super(Version.LUCENE_46, stopSet);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WikipediaTokenizer tokenizer = new WikipediaTokenizer(reader);
        TokenFilter result = new StandardFilter(Version.LUCENE_46, tokenizer);
        result = new LowerCaseFilter(Version.LUCENE_46, result);
        result = new StopFilter(Version.LUCENE_46, result, this.getStopwordSet());
        return new Analyzer.TokenStreamComponents(tokenizer, result);
    }
}

