/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.base.Joiner;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.text.LuceneSegmentInputFormat;
import org.apache.mahout.text.LuceneStorageConfiguration;
import org.apache.mahout.text.SequenceFilesFromLuceneStorageMapper;

public class SequenceFilesFromLuceneStorageMRJob {
    public void run(LuceneStorageConfiguration lucene2seqConf) {
        try {
            Configuration configuration = lucene2seqConf.serialize();
            Job job = new Job(configuration, "LuceneIndexToSequenceFiles: " + lucene2seqConf.getIndexPaths() + " -> M/R -> " + lucene2seqConf.getSequenceFilesOutputPath());
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(Text.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Text.class);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setMapperClass(SequenceFilesFromLuceneStorageMapper.class);
            job.setInputFormatClass(LuceneSegmentInputFormat.class);
            FileInputFormat.setInputPaths(job, Joiner.on(',').skipNulls().join(lucene2seqConf.getIndexPaths().iterator()));
            FileOutputFormat.setOutputPath(job, lucene2seqConf.getSequenceFilesOutputPath());
            job.setJarByClass(SequenceFilesFromLuceneStorageMRJob.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

