/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.text.SequenceFilesFromDirectory;

public class SequenceFilesFromDirectoryMapper
extends Mapper<IntWritable, BytesWritable, Text, Text> {
    private String keyPrefix;
    private Text fileValue = new Text();

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyPrefix = context.getConfiguration().get(SequenceFilesFromDirectory.KEY_PREFIX_OPTION[0], "");
    }

    @Override
    public void map(IntWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        Path filePath = ((CombineFileSplit)context.getInputSplit()).getPath(key.get());
        String relativeFilePath = HadoopUtil.calcRelativeFilePath(configuration, filePath);
        String filename = this.keyPrefix.length() > 0 ? this.keyPrefix + "/" + relativeFilePath : "/" + relativeFilePath;
        this.fileValue.set(value.getBytes(), 0, value.getBytes().length);
        context.write(new Text(filename), this.fileValue);
    }
}

