/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.mahout.text.LuceneIndexFileNameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyFileSystemDirectory
extends BaseDirectory {
    private final FileSystem fs;
    private final Path directory;
    private final int ioFileBufferSize;
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyFileSystemDirectory.class);

    public ReadOnlyFileSystemDirectory(FileSystem fs, Path directory, boolean create, Configuration conf) throws IOException {
        this.fs = fs;
        this.directory = directory;
        this.ioFileBufferSize = conf.getInt("io.file.buffer.size", 4096);
        if (create) {
            this.create();
        }
        boolean isDir = false;
        try {
            FileStatus status = fs.getFileStatus(directory);
            if (status != null) {
                isDir = status.isDir();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!isDir) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private void create() throws IOException {
        FileStatus[] fileStatus;
        if (!this.fs.exists(this.directory)) {
            this.fs.mkdirs(this.directory);
        }
        boolean isDir = false;
        try {
            FileStatus status = this.fs.getFileStatus(this.directory);
            if (status != null) {
                isDir = status.isDir();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!isDir) {
            throw new IOException(this.directory + " is not a directory");
        }
        for (FileStatus status : fileStatus = this.fs.listStatus(this.directory, (PathFilter)LuceneIndexFileNameFilter.getFilter())) {
            if (this.fs.delete(status.getPath(), true)) continue;
            throw new IOException("Cannot delete index file " + status.getPath());
        }
    }

    public String[] list() throws IOException {
        FileStatus[] fileStatus = this.fs.listStatus(this.directory, (PathFilter)LuceneIndexFileNameFilter.getFilter());
        String[] result = new String[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            result[i] = fileStatus[i].getPath().getName();
        }
        return result;
    }

    @Override
    public String[] listAll() throws IOException {
        return this.list();
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.fs.exists(new Path(this.directory, name));
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.fs.getFileStatus(new Path(this.directory, name)).getLen();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (!this.fs.delete(new Path(this.directory, name), true)) {
            throw new IOException("Cannot delete index file " + name);
        }
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        Path file = new Path(this.directory, name);
        if (this.fs.exists(file) && !this.fs.delete(file, true)) {
            throw new IOException("Cannot overwrite index file " + file);
        }
        return new FileSystemIndexOutput(file, this.ioFileBufferSize);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        return new FileSystemIndexInput(new Path(this.directory, name), this.ioFileBufferSize);
    }

    @Override
    public Lock makeLock(final String name) {
        return new Lock(){

            @Override
            public boolean obtain() {
                return true;
            }

            @Override
            public void release() {
            }

            @Override
            public boolean isLocked() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "Lock@" + new Path(ReadOnlyFileSystemDirectory.this.directory, name);
            }
        };
    }

    @Override
    public void clearLock(String name) throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
    }

    @Override
    public LockFactory getLockFactory() {
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.directory;
    }

    private class FileSystemIndexOutput
    extends BufferedIndexOutput {
        private final Path filePath;
        private final FSDataOutputStream out;
        private boolean isOpen;

        public FileSystemIndexOutput(Path path, int ioFileBufferSize) throws IOException {
            this.filePath = path;
            this.out = ReadOnlyFileSystemDirectory.this.fs.create(path, true, ioFileBufferSize);
            this.isOpen = true;
        }

        @Override
        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.out.write(b, offset, size);
        }

        @Override
        public void close() throws IOException {
            if (!this.isOpen) {
                throw new IOException("Index file " + this.filePath + " already closed");
            }
            super.close();
            this.out.close();
            this.isOpen = false;
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() throws IOException {
            return this.out.getPos();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.isOpen) {
                this.close();
            }
        }
    }

    private class FileSystemIndexInput
    extends BufferedIndexInput
    implements Cloneable {
        private final Path filePath;
        private final Descriptor descriptor;
        private final long length;
        private boolean isOpen;
        private boolean isClone;

        public FileSystemIndexInput(Path path, int ioFileBufferSize) throws IOException {
            super("FSII_" + path.getName(), ioFileBufferSize);
            this.filePath = path;
            this.descriptor = new Descriptor(path, ioFileBufferSize);
            this.length = ReadOnlyFileSystemDirectory.this.fs.getFileStatus(path).getLen();
            this.isOpen = true;
        }

        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            int i;
            long position = this.getFilePointer();
            if (position != this.descriptor.position) {
                this.descriptor.in.seek(position);
                this.descriptor.position = position;
            }
            int total = 0;
            do {
                if ((i = this.descriptor.in.read(b, offset + total, len - total)) == -1) {
                    throw new IOException("Read past EOF");
                }
                this.descriptor.position += (long)i;
            } while ((total += i) < len);
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                if (this.isOpen) {
                    this.descriptor.in.close();
                    this.isOpen = false;
                } else {
                    throw new IOException("Index file " + this.filePath + " already closed");
                }
            }
        }

        @Override
        protected void seekInternal(long position) {
        }

        @Override
        public long length() {
            return this.length;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.isClone && this.isOpen) {
                this.close();
            }
        }

        @Override
        public BufferedIndexInput clone() {
            FileSystemIndexInput clone = (FileSystemIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        private class Descriptor {
            public final FSDataInputStream in;
            public long position;

            public Descriptor(Path file, int ioFileBufferSize) throws IOException {
                this.in = ReadOnlyFileSystemDirectory.this.fs.open(file, ioFileBufferSize);
            }
        }
    }
}

