/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.mahout.text.ReadOnlyFileSystemDirectory;

public class LuceneSegmentInputSplit
extends InputSplit
implements Writable {
    private Path indexPath;
    private String segmentInfoName;
    private long length;

    public LuceneSegmentInputSplit() {
    }

    public LuceneSegmentInputSplit(Path indexPath, String segmentInfoName, long length) {
        this.indexPath = indexPath;
        this.segmentInfoName = segmentInfoName;
        this.length = length;
    }

    @Override
    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    @Override
    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public String getSegmentInfoName() {
        return this.segmentInfoName;
    }

    public Path getIndexPath() {
        return this.indexPath;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.indexPath.toString());
        out.writeUTF(this.segmentInfoName);
        out.writeLong(this.length);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.indexPath = new Path(in.readUTF());
        this.segmentInfoName = in.readUTF();
        this.length = in.readLong();
    }

    public SegmentCommitInfo getSegment(Configuration configuration) throws IOException {
        ReadOnlyFileSystemDirectory directory = new ReadOnlyFileSystemDirectory(FileSystem.get(configuration), this.indexPath, false, configuration);
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        for (SegmentCommitInfo segmentInfo : segmentInfos) {
            if (!segmentInfo.info.name.equals(this.segmentInfoName)) continue;
            return segmentInfo;
        }
        throw new IllegalArgumentException("No such segment: '" + this.segmentInfoName + "' in directory " + directory.toString());
    }
}

