/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.solver;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LSMR {
    private static final Logger log = LoggerFactory.getLogger(LSMR.class);
    private final double lambda;
    private int localSize = 0;
    private int iterationLimit = -1;
    private double conditionLimit = 1.0E8;
    private double bTolerance = 1.0E-6;
    private double aTolerance = 1.0E-6;
    private int localPointer;
    private Vector[] localV;
    private double residualNorm;
    private double normalEquationResidual;
    private double xNorm;
    private int iteration;
    private double normA;
    private double condA;

    public int getIterationCount() {
        return this.iteration;
    }

    public double getResidualNorm() {
        return this.residualNorm;
    }

    public double getNormalEquationResidual() {
        return this.normalEquationResidual;
    }

    public double getANorm() {
        return this.normA;
    }

    public double getCondition() {
        return this.condA;
    }

    public double getXNorm() {
        return this.xNorm;
    }

    public LSMR() {
        this.lambda = 0.0;
    }

    public Vector solve(Matrix A2, Vector b) {
        double alpha;
        log.debug("   itn         x(1)     norm r   norm A'r");
        log.debug("   compatible   LS      norm A   cond A");
        Matrix transposedA = A2.transpose();
        Vector u = b;
        double beta = u.norm(2.0);
        if (beta > 0.0) {
            u = u.divide(beta);
        }
        Vector v = transposedA.times(u);
        int m = A2.numRows();
        int n = A2.numCols();
        int minDim = Math.min(m, n);
        if (this.iterationLimit == -1) {
            this.iterationLimit = minDim;
        }
        if (log.isDebugEnabled()) {
            log.debug("LSMR - Least-squares solution of  Ax = b, based on Matlab Version 1.02, 14 Apr 2010, Mahout version {}", (Object)this.getClass().getPackage().getImplementationVersion());
            log.debug(String.format("The matrix A has %d rows  and %d cols, lambda = %.4g, atol = %g, btol = %g", m, n, this.lambda, this.aTolerance, this.bTolerance));
        }
        if ((alpha = v.norm(2.0)) > 0.0) {
            v.assign(Functions.div(alpha));
        }
        this.localPointer = 0;
        this.localV = new Vector[Math.min(this.localSize, minDim)];
        boolean localOrtho = false;
        if (this.localSize > 0) {
            localOrtho = true;
            this.localV[0] = v;
        }
        this.iteration = 0;
        double zetabar = alpha * beta;
        double alphabar = alpha;
        Vector h = v;
        Vector hbar = LSMR.zeros(n);
        Vector x = LSMR.zeros(n);
        double betadd = beta;
        double aNorm = alpha * alpha;
        double normb = beta;
        double ctol = 0.0;
        if (this.conditionLimit > 0.0) {
            ctol = 1.0 / this.conditionLimit;
        }
        this.residualNorm = beta;
        this.normalEquationResidual = alpha * beta;
        if (this.normalEquationResidual == 0.0) {
            return x;
        }
        if (log.isDebugEnabled()) {
            double test2 = alpha / beta;
            log.debug("{} {}", (Object)this.iteration, (Object)x.get(0));
            log.debug("{} {}", (Object)this.residualNorm, (Object)this.normalEquationResidual);
            double test1 = 1.0;
            log.debug("{} {}", (Object)test1, (Object)test2);
        }
        double rho = 1.0;
        double rhobar = 1.0;
        double cbar = 1.0;
        double sbar = 0.0;
        double betad = 0.0;
        double rhodold = 1.0;
        double tautildeold = 0.0;
        double thetatilde = 0.0;
        double zeta = 0.0;
        double d = 0.0;
        double maxrbar = 0.0;
        double minrbar = 1.0E100;
        StopCode stop = StopCode.CONTINUE;
        while (this.iteration <= this.iterationLimit && stop == StopCode.CONTINUE) {
            ++this.iteration;
            u = A2.times(v).minus(u.times(alpha));
            beta = u.norm(2.0);
            if (beta > 0.0) {
                u.assign(Functions.div(beta));
                if (localOrtho) {
                    this.localVEnqueue(v);
                }
                v = transposedA.times(u).minus(v.times(beta));
                if (localOrtho) {
                    v = this.localVOrtho(v);
                }
                if ((alpha = v.norm(2.0)) > 0.0) {
                    v.assign(Functions.div(alpha));
                }
            }
            double alphahat = Math.hypot(alphabar, this.lambda);
            double chat = alphabar / alphahat;
            double shat = this.lambda / alphahat;
            double rhoold = rho;
            rho = Math.hypot(alphahat, beta);
            double c = alphahat / rho;
            double s = beta / rho;
            double thetanew = s * alpha;
            alphabar = c * alpha;
            double rhobarold = rhobar;
            double zetaold = zeta;
            double thetabar = sbar * rho;
            double rhotemp = cbar * rho;
            rhobar = Math.hypot(cbar * rho, thetanew);
            cbar = cbar * rho / rhobar;
            sbar = thetanew / rhobar;
            zeta = cbar * zetabar;
            zetabar = -sbar * zetabar;
            hbar = h.minus(hbar.times(thetabar * rho / (rhoold * rhobarold)));
            x.assign(hbar.times(zeta / (rho * rhobar)), Functions.PLUS);
            h = v.minus(h.times(thetanew / rho));
            double betaacute = chat * betadd;
            double betacheck = -shat * betadd;
            double betahat = c * betaacute;
            betadd = -s * betaacute;
            double thetatildeold = thetatilde;
            double rhotildeold = Math.hypot(rhodold, thetabar);
            double ctildeold = rhodold / rhotildeold;
            double stildeold = thetabar / rhotildeold;
            thetatilde = stildeold * rhobar;
            rhodold = ctildeold * rhobar;
            betad = -stildeold * betad + ctildeold * betahat;
            tautildeold = (zetaold - thetatildeold * tautildeold) / rhotildeold;
            double taud = (zeta - thetatilde * tautildeold) / rhodold;
            this.residualNorm = Math.sqrt((d += betacheck * betacheck) + (betad - taud) * (betad - taud) + betadd * betadd);
            this.normA = Math.sqrt(aNorm += beta * beta);
            aNorm += alpha * alpha;
            maxrbar = Math.max(maxrbar, rhobarold);
            if (this.iteration > 1) {
                minrbar = Math.min(minrbar, rhobarold);
            }
            this.condA = Math.max(maxrbar, rhotemp) / Math.min(minrbar, rhotemp);
            this.normalEquationResidual = Math.abs(zetabar);
            this.xNorm = x.norm(2.0);
            double test1 = this.residualNorm / normb;
            double test2 = this.normalEquationResidual / (this.normA * this.residualNorm);
            double test3 = 1.0 / this.condA;
            double t1 = test1 / (1.0 + this.normA * this.xNorm / normb);
            double rtol = this.bTolerance + this.aTolerance * this.normA * this.xNorm / normb;
            if (this.iteration > this.iterationLimit) {
                stop = StopCode.ITERATION_LIMIT;
            }
            if (1.0 + test3 <= 1.0) {
                stop = StopCode.CONDITION_MACHINE_TOLERANCE;
            }
            if (1.0 + test2 <= 1.0) {
                stop = StopCode.LEAST_SQUARE_CONVERGED_MACHINE_TOLERANCE;
            }
            if (1.0 + t1 <= 1.0) {
                stop = StopCode.CONVERGED_MACHINE_TOLERANCE;
            }
            if (test3 <= ctol) {
                stop = StopCode.CONDITION;
            }
            if (test2 <= this.aTolerance) {
                stop = StopCode.CONVERGED;
            }
            if (test1 <= rtol) {
                stop = StopCode.TRIVIAL;
            }
            if (!log.isDebugEnabled() || !(n <= 40 || this.iteration <= 10 || this.iteration >= this.iterationLimit - 10 || this.iteration % 10 == 0 || test3 <= 1.1 * ctol || test2 <= 1.1 * this.aTolerance || test1 <= 1.1 * rtol) && stop == StopCode.CONTINUE) continue;
            this.statusDump(x, this.normA, this.condA, test1, test2);
        }
        log.debug("Finished: {}", (Object)stop.getMessage());
        return x;
    }

    private void statusDump(Vector x, double normA, double condA, double test1, double test2) {
        log.debug("{} {}", (Object)this.residualNorm, (Object)this.normalEquationResidual);
        log.debug("{} {}", (Object)this.iteration, (Object)x.get(0));
        log.debug("{} {}", (Object)test1, (Object)test2);
        log.debug("{} {}", (Object)normA, (Object)condA);
    }

    private static Vector zeros(int n) {
        return new DenseVector(n);
    }

    private void localVEnqueue(Vector v) {
        if (this.localV.length > 0) {
            this.localV[this.localPointer] = v;
            this.localPointer = (this.localPointer + 1) % this.localV.length;
        }
    }

    private Vector localVOrtho(Vector v) {
        for (Vector old : this.localV) {
            if (old == null) continue;
            double x = v.dot(old);
            v = v.minus(old.times(x));
        }
        return v;
    }

    public void setAtolerance(double aTolerance) {
        this.aTolerance = aTolerance;
    }

    public void setBtolerance(double bTolerance) {
        this.bTolerance = bTolerance;
    }

    public void setConditionLimit(double conditionLimit) {
        this.conditionLimit = conditionLimit;
    }

    public void setIterationLimit(int iterationLimit) {
        this.iterationLimit = iterationLimit;
    }

    public void setLocalSize(int localSize) {
        this.localSize = localSize;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getAtolerance() {
        return this.aTolerance;
    }

    public double getBtolerance() {
        return this.bTolerance;
    }

    private static enum StopCode {
        CONTINUE("Not done"),
        TRIVIAL("The exact solution is  x = 0"),
        CONVERGED("Ax - b is small enough, given atol, btol"),
        LEAST_SQUARE_CONVERGED("The least-squares solution is good enough, given atol"),
        CONDITION("The estimate of cond(Abar) has exceeded condition limit"),
        CONVERGED_MACHINE_TOLERANCE("Ax - b is small enough for this machine"),
        LEAST_SQUARE_CONVERGED_MACHINE_TOLERANCE("The least-squares solution is good enough for this machine"),
        CONDITION_MACHINE_TOLERANCE("Cond(Abar) seems to be too large for this machine"),
        ITERATION_LIMIT("The iteration limit has been reached");

        private final String message;

        private StopCode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

