/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.WeightedThing;

public class BruteSearch
extends UpdatableSearcher {
    private final List<Vector> referenceVectors = Lists.newArrayList();

    public BruteSearch(DistanceMeasure distanceMeasure) {
        super(distanceMeasure);
    }

    @Override
    public void add(Vector vector) {
        this.referenceVectors.add(vector);
    }

    @Override
    public int size() {
        return this.referenceVectors.size();
    }

    @Override
    public List<WeightedThing<Vector>> search(Vector query, int limit) {
        Preconditions.checkArgument(limit > 0, "limit must be greater then 0!");
        limit = Math.min(limit, this.referenceVectors.size());
        PriorityQueue bestNeighbors = new PriorityQueue(limit, Ordering.natural().reverse());
        ArrayList<WeightedThing<Vector>> results = Lists.newArrayListWithCapacity(limit);
        int rowNumber = 0;
        for (Vector row : this.referenceVectors) {
            double distance = this.distanceMeasure.distance(query, row);
            if (bestNeighbors.size() < limit || ((WeightedThing)bestNeighbors.peek()).getWeight() > distance) {
                bestNeighbors.add(new WeightedThing<Integer>(rowNumber, distance));
                if (bestNeighbors.size() > limit) {
                    bestNeighbors.poll();
                } else {
                    results.add(null);
                }
            }
            ++rowNumber;
        }
        for (int i = limit - 1; i >= 0; --i) {
            WeightedThing neighbor = (WeightedThing)bestNeighbors.poll();
            results.set(i, new WeightedThing<Vector>(this.referenceVectors.get((Integer)neighbor.getValue()), neighbor.getWeight()));
        }
        return results;
    }

    @Override
    public WeightedThing<Vector> searchFirst(Vector query, boolean differentThanQuery) {
        double bestDistance = Double.POSITIVE_INFINITY;
        Vector bestVector = null;
        for (Vector row : this.referenceVectors) {
            double distance = this.distanceMeasure.distance(query, row);
            if (!(distance < bestDistance) || differentThanQuery && row.equals(query)) continue;
            bestDistance = distance;
            bestVector = row;
        }
        return new WeightedThing<Object>(bestVector, bestDistance);
    }

    public List<List<WeightedThing<Vector>>> search(Iterable<WeightedVector> queries, final int limit, int numThreads) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList<1> tasks = Lists.newArrayList();
        final ArrayList<List<WeightedThing<Vector>>> results = Lists.newArrayList();
        int i = 0;
        for (final WeightedVector query : queries) {
            results.add(null);
            final int index = i++;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    results.set(index, BruteSearch.this.search(query, limit));
                    return null;
                }
            });
        }
        executor.invokeAll(tasks);
        executor.shutdown();
        return results;
    }

    @Override
    public Iterator<Vector> iterator() {
        return this.referenceVectors.iterator();
    }

    @Override
    public boolean remove(Vector query, double epsilon) {
        int rowNumber = 0;
        for (Vector row : this.referenceVectors) {
            double distance = this.distanceMeasure.distance(query, row);
            if (distance < epsilon) {
                this.referenceVectors.remove(rowNumber);
                return true;
            }
            ++rowNumber;
        }
        return false;
    }

    @Override
    public void clear() {
        this.referenceVectors.clear();
    }
}

