/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.stochasticsvd.SparseRowBlockWritable;

public class SparseRowBlockAccumulator
implements OutputCollector<Long, Vector>,
Closeable {
    private final int height;
    private final OutputCollector<LongWritable, SparseRowBlockWritable> delegate;
    private long currentBlockNum = -1L;
    private SparseRowBlockWritable block;
    private final LongWritable blockKeyW = new LongWritable();

    public SparseRowBlockAccumulator(int height, OutputCollector<LongWritable, SparseRowBlockWritable> delegate) {
        this.height = height;
        this.delegate = delegate;
    }

    private void flushBlock() throws IOException {
        if (this.block == null || this.block.getNumRows() == 0) {
            return;
        }
        this.blockKeyW.set(this.currentBlockNum);
        this.delegate.collect(this.blockKeyW, this.block);
        this.block.clear();
    }

    @Override
    public void collect(Long rowIndex, Vector v) throws IOException {
        long blockKey = rowIndex / (long)this.height;
        if (blockKey != this.currentBlockNum) {
            this.flushBlock();
            if (this.block == null) {
                this.block = new SparseRowBlockWritable(100);
            }
            this.currentBlockNum = blockKey;
        }
        this.block.plusRow((int)(rowIndex % (long)this.height), v);
    }

    @Override
    public void close() throws IOException {
        this.flushBlock();
    }
}

