/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SeedVectorUtil {
    private static final Logger log = LoggerFactory.getLogger(SeedVectorUtil.class);

    private SeedVectorUtil() {
    }

    public static List<NamedVector> loadSeedVectors(Configuration conf) {
        String seedPathStr = conf.get("seedsPath");
        if (seedPathStr == null || seedPathStr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NamedVector> seedVectors = Lists.newArrayList();
        long item = 0L;
        for (Writable value : new SequenceFileDirValueIterable(new Path(seedPathStr), PathType.LIST, PathFilters.partFilter(), conf)) {
            Vector vector;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(Kluster.class)) {
                Kluster cluster = (Kluster)value;
                vector = cluster.getCenter();
                if (vector instanceof NamedVector) {
                    seedVectors.add((NamedVector)vector);
                    continue;
                }
                seedVectors.add(new NamedVector(vector, cluster.getIdentifier()));
                continue;
            }
            if (valueClass.equals(Canopy.class)) {
                Canopy canopy = (Canopy)value;
                vector = canopy.getCenter();
                if (vector instanceof NamedVector) {
                    seedVectors.add((NamedVector)vector);
                    continue;
                }
                seedVectors.add(new NamedVector(vector, canopy.getIdentifier()));
                continue;
            }
            if (valueClass.equals(Vector.class)) {
                Vector vector2 = (Vector)((Object)value);
                if (vector2 instanceof NamedVector) {
                    seedVectors.add((NamedVector)vector2);
                    continue;
                }
                seedVectors.add(new NamedVector(vector2, seedPathStr + '.' + item++));
                continue;
            }
            if (valueClass.equals(VectorWritable.class) || valueClass.isInstance(VectorWritable.class)) {
                VectorWritable vw = (VectorWritable)value;
                vector = vw.get();
                if (vector instanceof NamedVector) {
                    seedVectors.add((NamedVector)vector);
                    continue;
                }
                seedVectors.add(new NamedVector(vector, seedPathStr + '.' + item++));
                continue;
            }
            throw new IllegalStateException("Bad value class: " + valueClass);
        }
        if (seedVectors.isEmpty()) {
            throw new IllegalStateException("No seeds found. Check your path: " + seedPathStr);
        }
        log.info("Seed Vectors size: {}", (Object)seedVectors.size());
        return seedVectors;
    }
}

