/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.io.Closeables;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public final class MatrixColumnMeansJob {
    public static final String VECTOR_CLASS = "DistributedRowMatrix.columnMeans.vector.class";

    private MatrixColumnMeansJob() {
    }

    public static Vector run(Configuration conf, Path inputPath, Path outputVectorTmpPath) throws IOException {
        return MatrixColumnMeansJob.run(conf, inputPath, outputVectorTmpPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector run(Configuration initialConf, Path inputPath, Path outputVectorTmpPath, String vectorClass) throws IOException {
        try {
            initialConf.set(VECTOR_CLASS, vectorClass == null ? DenseVector.class.getName() : vectorClass);
            Job job = new Job(initialConf, "MatrixColumnMeansJob");
            job.setJarByClass(MatrixColumnMeansJob.class);
            FileOutputFormat.setOutputPath(job, outputVectorTmpPath);
            outputVectorTmpPath.getFileSystem(job.getConfiguration()).delete(outputVectorTmpPath, true);
            job.setNumReduceTasks(1);
            FileOutputFormat.setOutputPath(job, outputVectorTmpPath);
            FileInputFormat.addInputPath(job, inputPath);
            job.setInputFormatClass(SequenceFileInputFormat.class);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            FileOutputFormat.setOutputPath(job, outputVectorTmpPath);
            job.setMapperClass(MatrixColumnMeansMapper.class);
            job.setReducerClass(MatrixColumnMeansReducer.class);
            job.setMapOutputKeyClass(NullWritable.class);
            job.setMapOutputValueClass(VectorWritable.class);
            job.setOutputKeyClass(IntWritable.class);
            job.setOutputValueClass(VectorWritable.class);
            job.submit();
            job.waitForCompletion(true);
            Path tmpFile = new Path(outputVectorTmpPath, "part-r-00000");
            SequenceFileValueIterator iterator = new SequenceFileValueIterator(tmpFile, true, initialConf);
            try {
                if (iterator.hasNext()) {
                    Vector vector = ((VectorWritable)iterator.next()).get();
                    return vector;
                }
                Vector vector = (Vector)Class.forName(vectorClass).getConstructor(Integer.TYPE).newInstance(0);
                return vector;
            }
            finally {
                Closeables.close(iterator, true);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable thr) {
            throw new IOException(thr);
        }
    }

    public static class MatrixColumnMeansReducer
    extends Reducer<NullWritable, VectorWritable, IntWritable, VectorWritable> {
        private static final IntWritable ONE = new IntWritable(1);
        private String vectorClass;
        private Vector outputVector;
        private final VectorWritable outputVectorWritable = new VectorWritable();

        @Override
        public void setup(Reducer.Context context) {
            this.vectorClass = context.getConfiguration().get(MatrixColumnMeansJob.VECTOR_CLASS);
        }

        @Override
        public void reduce(NullWritable n, Iterable<VectorWritable> vectors, Reducer.Context context) throws IOException, InterruptedException {
            for (VectorWritable v : vectors) {
                if (this.outputVector == null) {
                    this.outputVector = v.get();
                    continue;
                }
                this.outputVector.assign(v.get(), Functions.PLUS);
            }
            if (this.outputVector != null) {
                this.outputVectorWritable.set(this.outputVector.viewPart(1, this.outputVector.size() - 1).divide(this.outputVector.get(0)));
                context.write(ONE, this.outputVectorWritable);
            } else {
                Vector emptyVector = ClassUtils.instantiateAs(this.vectorClass, Vector.class, new Class[]{Integer.TYPE}, new Object[]{0});
                context.write(ONE, new VectorWritable(emptyVector));
            }
        }
    }

    public static class MatrixColumnMeansMapper
    extends Mapper<Writable, VectorWritable, NullWritable, VectorWritable> {
        private Vector runningSum;
        private String vectorClass;

        @Override
        public void setup(Mapper.Context context) {
            this.vectorClass = context.getConfiguration().get(MatrixColumnMeansJob.VECTOR_CLASS);
        }

        @Override
        public void map(Writable r, VectorWritable v, Mapper.Context context) throws IOException {
            if (this.runningSum == null) {
                this.runningSum = ClassUtils.instantiateAs(this.vectorClass, Vector.class, new Class[]{Integer.TYPE}, new Object[]{v.get().size() + 1});
                this.runningSum.set(0, 1.0);
                this.runningSum.viewPart(1, v.get().size()).assign(v.get());
            } else {
                this.runningSum.set(0, this.runningSum.get(0) + 1.0);
                this.runningSum.viewPart(1, v.get().size()).assign(v.get(), Functions.PLUS);
            }
        }

        @Override
        public void cleanup(Mapper.Context context) throws InterruptedException, IOException {
            if (this.runningSum != null) {
                context.write(NullWritable.get(), new VectorWritable(this.runningSum));
            }
        }
    }
}

