/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;

public class VarIntWritable
implements WritableComparable<VarIntWritable>,
Cloneable {
    private int value;

    public VarIntWritable() {
    }

    public VarIntWritable(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value;
    }

    public boolean equals(Object other) {
        return other instanceof VarIntWritable && ((VarIntWritable)other).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public VarIntWritable clone() {
        return new VarIntWritable(this.value);
    }

    @Override
    public int compareTo(VarIntWritable other) {
        if (this.value < other.value) {
            return -1;
        }
        if (this.value > other.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarInt(this.value, out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = Varint.readSignedVarInt(in);
    }
}

