/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Locale;
import org.apache.mahout.math.Algebra;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QR;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class OldQRDecomposition
implements QR {
    private final Matrix qr;
    private final int originalRows;
    private final int originalColumns;
    private final Vector rDiag;

    public OldQRDecomposition(Matrix a) {
        int k;
        this.qr = a.clone();
        this.originalRows = a.numRows();
        this.originalColumns = a.numCols();
        this.rDiag = new DenseVector(this.originalColumns);
        Vector[] QRcolumnsPart = new Vector[this.originalColumns];
        for (k = 0; k < this.originalColumns; ++k) {
            QRcolumnsPart[k] = this.qr.viewColumn(k).viewPart(k, this.originalRows - k);
        }
        for (k = 0; k < this.originalColumns; ++k) {
            double nrm = 0.0;
            for (int i = k; i < this.originalRows; ++i) {
                nrm = Algebra.hypot(nrm, this.qr.getQuick(i, k));
            }
            if (nrm != 0.0) {
                if (this.qr.getQuick(k, k) < 0.0) {
                    nrm = -nrm;
                }
                QRcolumnsPart[k].assign(Functions.div(nrm));
                this.qr.setQuick(k, k, this.qr.getQuick(k, k) + 1.0);
                for (int j = k + 1; j < this.originalColumns; ++j) {
                    Vector QRcolj = this.qr.viewColumn(j).viewPart(k, this.originalRows - k);
                    double s = QRcolumnsPart[k].dot(QRcolj);
                    s = -s / this.qr.getQuick(k, k);
                    for (int i = k; i < this.originalRows; ++i) {
                        this.qr.setQuick(i, j, this.qr.getQuick(i, j) + s * this.qr.getQuick(i, k));
                    }
                }
            }
            this.rDiag.setQuick(k, -nrm);
        }
    }

    @Override
    public Matrix getQ() {
        int columns = Math.min(this.originalColumns, this.originalRows);
        Matrix q = this.qr.like(this.originalRows, columns);
        for (int k = columns - 1; k >= 0; --k) {
            Vector QRcolk = this.qr.viewColumn(k).viewPart(k, this.originalRows - k);
            q.set(k, k, 1.0);
            for (int j = k; j < columns; ++j) {
                if (this.qr.get(k, k) == 0.0) continue;
                Vector Qcolj = q.viewColumn(j).viewPart(k, this.originalRows - k);
                double s = -QRcolk.dot(Qcolj) / this.qr.get(k, k);
                Qcolj.assign(QRcolk, Functions.plusMult(s));
            }
        }
        return q;
    }

    @Override
    public Matrix getR() {
        int rows = Math.min(this.originalRows, this.originalColumns);
        Matrix r = this.qr.like(rows, this.originalColumns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < this.originalColumns; ++j) {
                if (i < j) {
                    r.setQuick(i, j, this.qr.getQuick(i, j));
                    continue;
                }
                if (i == j) {
                    r.setQuick(i, j, this.rDiag.getQuick(i));
                    continue;
                }
                r.setQuick(i, j, 0.0);
            }
        }
        return r;
    }

    @Override
    public boolean hasFullRank() {
        for (int j = 0; j < this.originalColumns; ++j) {
            if (this.rDiag.getQuick(j) != 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix solve(Matrix B2) {
        if (B2.numRows() != this.originalRows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        int columns = B2.numCols();
        Matrix x = B2.like(this.originalColumns, columns);
        Matrix qt = this.getQ().transpose();
        Matrix y = qt.times(B2);
        Matrix r = this.getR();
        for (int k = Math.min(this.originalColumns, this.originalRows) - 1; k >= 0; --k) {
            x.viewRow(k).assign(y.viewRow(k), Functions.plusMult(1.0 / r.get(k, k)));
            Vector rColumn = r.viewColumn(k).viewPart(0, k);
            for (int c = 0; c < columns; ++c) {
                y.viewColumn(c).viewPart(0, k).assign(rColumn, Functions.plusMult(-x.get(k, c)));
            }
        }
        return x;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "QR(%d,%d,fullRank=%s)", this.originalColumns, this.originalRows, this.hasFullRank());
    }
}

