/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.VectorWritable;

public final class DistributedRowMatrixWriter {
    private DistributedRowMatrixWriter() {
    }

    public static void write(Path outputDir, Configuration conf, Iterable<MatrixSlice> matrix) throws IOException {
        FileSystem fs = outputDir.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter(fs, conf, outputDir, IntWritable.class, VectorWritable.class);
        IntWritable topic = new IntWritable();
        VectorWritable vector = new VectorWritable();
        for (MatrixSlice slice : matrix) {
            topic.set(slice.index());
            vector.set(slice.vector());
            writer.append(topic, vector);
        }
        writer.close();
    }
}

