/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.fpm.pfpgrowth.CountDescendingPairComparator;
import org.apache.mahout.fpm.pfpgrowth.convertors.TopKPatternsOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.TransactionIterator;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FrequentPatternMaxHeap;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.Pattern;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth2.FPTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPGrowthObj<A extends Comparable<? super A>> {
    private static final Logger log = LoggerFactory.getLogger(FPGrowthObj.class);

    public static List<Pair<String, TopKStringPatterns>> readFrequentPattern(Configuration conf, Path path) {
        ArrayList<Pair<String, TopKStringPatterns>> ret = Lists.newArrayList();
        for (Pair record : new SequenceFileIterable(path, true, conf)) {
            ret.add(new Pair<String, TopKStringPatterns>(((Writable)record.getFirst()).toString(), new TopKStringPatterns(((TopKStringPatterns)record.getSecond()).getPatterns())));
        }
        return ret;
    }

    public final List<Pair<A, Long>> generateFList(Iterator<Pair<List<A>, Long>> transactions, int minSupport) {
        HashMap<Comparable, MutableLong> attributeSupport = Maps.newHashMap();
        while (transactions.hasNext()) {
            Pair<List<A>, Long> transaction = transactions.next();
            for (Comparable attribute : transaction.getFirst()) {
                if (attributeSupport.containsKey(attribute)) {
                    ((MutableLong)attributeSupport.get(attribute)).add(transaction.getSecond());
                    continue;
                }
                attributeSupport.put(attribute, new MutableLong(transaction.getSecond()));
            }
        }
        ArrayList<Pair<A, Long>> fList = Lists.newArrayList();
        for (Map.Entry e : attributeSupport.entrySet()) {
            long value = ((MutableLong)e.getValue()).longValue();
            if (value < (long)minSupport) continue;
            fList.add(new Pair(e.getKey(), value));
        }
        Collections.sort(fList, new CountDescendingPairComparator());
        return fList;
    }

    public final void generateTopKFrequentPatterns(Iterator<Pair<List<A>, Long>> transactionStream, Collection<Pair<A, Long>> frequencyList, long minSupport, int k, Collection<A> returnableFeatures, OutputCollector<A, List<Pair<List<A>, Long>>> output) throws IOException {
        HashMap<Integer, Comparable> reverseMapping = Maps.newHashMap();
        HashMap<Comparable, Integer> attributeIdMapping = Maps.newHashMap();
        int id = 0;
        for (Pair<A, Long> feature : frequencyList) {
            Comparable attrib = (Comparable)feature.getFirst();
            Long frequency = feature.getSecond();
            if (frequency < minSupport) continue;
            attributeIdMapping.put(attrib, id);
            reverseMapping.put(id++, attrib);
        }
        long[] attributeFrequency = new long[attributeIdMapping.size()];
        for (Pair<A, Long> feature : frequencyList) {
            Comparable attrib = (Comparable)feature.getFirst();
            Long frequency = feature.getSecond();
            if (frequency < minSupport) break;
            attributeFrequency[((Integer)attributeIdMapping.get((Object)attrib)).intValue()] = frequency;
        }
        log.info("Number of unique items {}", (Object)frequencyList.size());
        HashSet<Integer> returnFeatures = Sets.newHashSet();
        if (returnableFeatures != null && !returnableFeatures.isEmpty()) {
            for (Comparable attrib : returnableFeatures) {
                if (!attributeIdMapping.containsKey(attrib)) continue;
                returnFeatures.add((Integer)attributeIdMapping.get(attrib));
                log.info("Adding Pattern {}=>{}", (Object)attrib, attributeIdMapping.get(attrib));
            }
        } else {
            for (int j = 0; j < attributeIdMapping.size(); ++j) {
                returnFeatures.add(j);
            }
        }
        log.info("Number of unique pruned items {}", (Object)attributeIdMapping.size());
        this.generateTopKFrequentPatterns(new TransactionIterator(transactionStream, attributeIdMapping), attributeFrequency, minSupport, k, returnFeatures, new TopKPatternsOutputConverter<A>(output, reverseMapping));
    }

    private Map<Integer, FrequentPatternMaxHeap> fpGrowth(FPTree tree, long minSupportValue, int k, Collection<Integer> requiredFeatures, TopKPatternsOutputConverter<A> outputCollector) throws IOException {
        HashMap<Integer, FrequentPatternMaxHeap> patterns = Maps.newHashMap();
        for (int attribute : tree.attrIterableRev()) {
            if (!requiredFeatures.contains(attribute)) continue;
            log.info("Mining FTree Tree for all patterns with {}", (Object)attribute);
            MutableLong minSupport = new MutableLong(minSupportValue);
            FrequentPatternMaxHeap frequentPatterns = FPGrowthObj.growth(tree, minSupport, k, attribute);
            patterns.put(attribute, frequentPatterns);
            outputCollector.collect(attribute, frequentPatterns);
            minSupportValue = Math.max(minSupportValue, minSupport.longValue() / 2L);
            log.info("Found {} Patterns with Least Support {}", (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).count(), (Object)((FrequentPatternMaxHeap)patterns.get(attribute)).leastSupport());
        }
        return patterns;
    }

    private void generateTopKFrequentPatterns(Iterator<Pair<int[], Long>> transactions, long[] attributeFrequency, long minSupport, int k, Collection<Integer> returnFeatures, TopKPatternsOutputConverter<A> topKPatternsOutputCollector) throws IOException {
        FPTree tree = new FPTree(attributeFrequency, minSupport);
        int i = 0;
        while (transactions.hasNext()) {
            int[] iArr;
            Pair<int[], Long> transaction = transactions.next();
            ArrayList<Integer> iLst = Lists.newArrayList();
            for (int anIArr : iArr = transaction.getFirst()) {
                iLst.add(anIArr);
            }
            tree.accumulate(iLst, (long)transaction.getSecond());
            if (++i % 10000 != 0) continue;
            log.info("FPTree Building: Read {} Transactions", (Object)i);
        }
        this.fpGrowth(tree, minSupport, k, returnFeatures, topKPatternsOutputCollector);
    }

    private static FrequentPatternMaxHeap growth(FPTree tree, MutableLong minSupportMutable, int k, int currentAttribute) {
        long currentAttributeCount = tree.headerCount(currentAttribute);
        if (currentAttributeCount < minSupportMutable.longValue()) {
            return new FrequentPatternMaxHeap(k, true);
        }
        FPTree condTree = tree.createMoreFreqConditionalTree(currentAttribute);
        Pair<FPTree, FPTree> pAndQ = condTree.splitSinglePrefix();
        FPTree p = pAndQ.getFirst();
        FPTree q = pAndQ.getSecond();
        FrequentPatternMaxHeap prefixPats = null;
        if (p != null) {
            prefixPats = FPGrowthObj.mineSinglePrefix(p, k);
        }
        FrequentPatternMaxHeap suffixPats = new FrequentPatternMaxHeap(k, true);
        Pattern thisPat = new Pattern();
        thisPat.add(currentAttribute, currentAttributeCount);
        suffixPats.insert(thisPat);
        for (int attr : q.attrIterableRev()) {
            FPGrowthObj.mergeHeap(suffixPats, FPGrowthObj.growth(q, minSupportMutable, k, attr), currentAttribute, currentAttributeCount, true);
        }
        if (prefixPats != null) {
            return FPGrowthObj.cross(prefixPats, suffixPats, k);
        }
        return suffixPats;
    }

    private static FrequentPatternMaxHeap cross(FrequentPatternMaxHeap pPats, FrequentPatternMaxHeap qPats, int k) {
        FrequentPatternMaxHeap pats = new FrequentPatternMaxHeap(k, true);
        for (Pattern p : pPats.getHeap()) {
            int[] pints = p.getPattern();
            for (Pattern q : qPats.getHeap()) {
                int[] qints = q.getPattern();
                Pattern pq = new Pattern();
                for (int pi = 0; pi < p.length(); ++pi) {
                    pq.add(pints[pi], p.support());
                }
                for (int qi = 0; qi < q.length(); ++qi) {
                    pq.add(qints[qi], q.support());
                }
                pats.insert(pq);
            }
        }
        for (Pattern q : qPats.getHeap()) {
            Pattern qq = new Pattern();
            int[] qints = q.getPattern();
            for (int qi = 0; qi < q.length(); ++qi) {
                qq.add(qints[qi], q.support());
            }
            pats.insert(qq);
        }
        return pats;
    }

    private static FrequentPatternMaxHeap mineSinglePrefix(FPTree tree, int k) {
        FrequentPatternMaxHeap pats = new FrequentPatternMaxHeap(k, true);
        FPTree.FPNode currNode = tree.root();
        while (currNode.numChildren() == 1) {
            currNode = currNode.children().iterator().next();
            FrequentPatternMaxHeap singlePat = new FrequentPatternMaxHeap(k, true);
            Pattern p = new Pattern();
            p.add(currNode.attribute(), currNode.count());
            singlePat.insert(p);
            pats = FPGrowthObj.cross(singlePat, pats, k);
            pats.insert(p);
        }
        return pats;
    }

    private static void mergeHeap(FrequentPatternMaxHeap frequentPatterns, FrequentPatternMaxHeap returnedPatterns, int attribute, long count, boolean addAttribute) {
        frequentPatterns.addAll(returnedPatterns, attribute, count);
        if (frequentPatterns.addable(count) && addAttribute) {
            Pattern p = new Pattern();
            p.add(attribute, count);
            frequentPatterns.insert(p);
        }
    }
}

