/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.CountDescendingPairComparator;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextStatusUpdater;
import org.apache.mahout.fpm.pfpgrowth.convertors.ContextWriteOutputCollector;
import org.apache.mahout.fpm.pfpgrowth.convertors.integer.IntegerStringOutputConverter;
import org.apache.mahout.fpm.pfpgrowth.convertors.string.TopKStringPatterns;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FPGrowth;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth2.FPGrowthIds;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;

public final class ParallelFPGrowthReducer
extends Reducer<IntWritable, TransactionTree, Text, TopKStringPatterns> {
    private final List<String> featureReverseMap = Lists.newArrayList();
    private final LongArrayList freqList = new LongArrayList();
    private int maxHeapSize = 50;
    private int minSupport = 3;
    private int numFeatures;
    private int maxPerGroup;
    private boolean useFP2;

    @Override
    protected void reduce(IntWritable key, Iterable<TransactionTree> values, Reducer.Context context) throws IOException {
        TransactionTree cTree = new TransactionTree();
        for (TransactionTree tr : values) {
            for (Pair<IntArrayList, Long> p : tr) {
                cTree.addPattern(p.getFirst(), p.getSecond());
            }
        }
        ArrayList localFList = Lists.newArrayList();
        for (Map.Entry<Integer, MutableLong> fItem : cTree.generateFList().entrySet()) {
            localFList.add(new Pair<Integer, Long>(fItem.getKey(), fItem.getValue().toLong()));
        }
        Collections.sort(localFList, new CountDescendingPairComparator());
        if (this.useFP2) {
            FPGrowthIds.generateTopKFrequentPatterns(cTree.iterator(), this.freqList, (long)this.minSupport, this.maxHeapSize, PFPGrowth.getGroupMembers(key.get(), this.maxPerGroup, this.numFeatures), new IntegerStringOutputConverter(new ContextWriteOutputCollector(context), this.featureReverseMap));
        } else {
            FPGrowth<Integer> fpGrowth = new FPGrowth<Integer>();
            fpGrowth.generateTopKFrequentPatterns(new IteratorAdapter(cTree.iterator()), localFList, this.minSupport, this.maxHeapSize, Sets.newHashSet(PFPGrowth.getGroupMembers(key.get(), this.maxPerGroup, this.numFeatures).toList()), new IntegerStringOutputConverter(new ContextWriteOutputCollector(context), this.featureReverseMap), new ContextStatusUpdater(context));
        }
    }

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        for (Pair<String, Long> e : PFPGrowth.readFList(context.getConfiguration())) {
            this.featureReverseMap.add(e.getFirst());
            this.freqList.add(e.getSecond());
        }
        this.maxHeapSize = Integer.valueOf(params.get("maxHeapSize", "50"));
        this.minSupport = Integer.valueOf(params.get("minSupport", "3"));
        this.maxPerGroup = params.getInt("maxPerGroup", 0);
        this.numFeatures = this.featureReverseMap.size();
        this.useFP2 = "true".equals(params.get("use_fpg2"));
    }

    private static final class IteratorAdapter
    implements Iterator<Pair<List<Integer>, Long>> {
        private final Iterator<Pair<IntArrayList, Long>> innerIter;

        private IteratorAdapter(Iterator<Pair<IntArrayList, Long>> transactionIter) {
            this.innerIter = transactionIter;
        }

        @Override
        public boolean hasNext() {
            return this.innerIter.hasNext();
        }

        @Override
        public Pair<List<Integer>, Long> next() {
            Pair<IntArrayList, Long> innerNext = this.innerIter.next();
            return new Pair<List<Integer>, Long>(innerNext.getFirst().toList(), innerNext.getSecond());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

