/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;
import org.apache.mahout.fpm.pfpgrowth.TransactionTree;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenObjectIntHashMap;
import org.apache.mahout.math.set.OpenIntHashSet;

public class ParallelFPGrowthMapper
extends Mapper<LongWritable, Text, IntWritable, TransactionTree> {
    private final OpenObjectIntHashMap<String> fMap = new OpenObjectIntHashMap();
    private Pattern splitter;
    private int maxPerGroup;
    private final IntWritable wGroupID = new IntWritable();

    @Override
    protected void map(LongWritable offset, Text input, Mapper.Context context) throws IOException, InterruptedException {
        String[] items = this.splitter.split(input.toString());
        OpenIntHashSet itemSet = new OpenIntHashSet();
        for (String item : items) {
            if (!this.fMap.containsKey(item) || item.trim().isEmpty()) continue;
            itemSet.add(this.fMap.get(item));
        }
        IntArrayList itemArr = new IntArrayList(itemSet.size());
        itemSet.keys(itemArr);
        itemArr.sort();
        OpenIntHashSet groups = new OpenIntHashSet();
        for (int j = itemArr.size() - 1; j >= 0; --j) {
            int item = itemArr.get(j);
            int groupID = PFPGrowth.getGroup(item, this.maxPerGroup);
            if (!groups.contains(groupID)) {
                IntArrayList tempItems = new IntArrayList(j + 1);
                tempItems.addAllOfFromTo(itemArr, 0, j);
                context.setStatus("Parallel FPGrowth: Generating Group Dependent transactions for: " + item);
                this.wGroupID.set(groupID);
                context.write(this.wGroupID, new TransactionTree(tempItems, 1L));
            }
            groups.add(groupID);
        }
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        int i = 0;
        for (Pair<String, Long> e : PFPGrowth.readFList(context.getConfiguration())) {
            this.fMap.put(e.getFirst(), i++);
        }
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        this.splitter = Pattern.compile(params.get("splitPattern", PFPGrowth.SPLITTER.toString()));
        this.maxPerGroup = params.getInt("maxPerGroup", 0);
    }
}

