/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ep;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.PolymorphicWritable;
import org.apache.mahout.math.function.DoubleFunction;

public abstract class Mapping
extends DoubleFunction
implements Writable {
    private Mapping() {
    }

    public static Mapping softLimit(double min, double max, double scale) {
        return new SoftLimit(min, max, scale);
    }

    public static Mapping softLimit(double min, double max) {
        return Mapping.softLimit(min, max, 1.0);
    }

    public static Mapping logLimit(double low, double high) {
        Preconditions.checkArgument(low > 0.0, "Lower bound for log limit must be > 0 but was %f", low);
        Preconditions.checkArgument(high > 0.0, "Upper bound for log limit must be > 0 but was %f", high);
        return new LogLimit(low, high);
    }

    public static Mapping exponential() {
        return Mapping.exponential(1.0);
    }

    public static Mapping exponential(double scale) {
        return new Exponential(scale);
    }

    public static Mapping identity() {
        return new Identity();
    }

    public static final class Identity
    extends Mapping {
        @Override
        public double apply(double v) {
            return v;
        }

        @Override
        public void write(DataOutput dataOutput) {
        }

        @Override
        public void readFields(DataInput dataInput) {
        }
    }

    public static final class Exponential
    extends Mapping {
        private double scale;

        public Exponential() {
        }

        private Exponential(double scale) {
            this.scale = scale;
        }

        @Override
        public double apply(double v) {
            return Math.exp(v * this.scale);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeDouble(this.scale);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.scale = in.readDouble();
        }
    }

    public static final class LogLimit
    extends Mapping {
        private Mapping wrapped;

        public LogLimit() {
        }

        private LogLimit(double low, double high) {
            this.wrapped = LogLimit.softLimit(Math.log(low), Math.log(high));
        }

        @Override
        public double apply(double v) {
            return Math.exp(this.wrapped.apply(v));
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            PolymorphicWritable.write(dataOutput, this.wrapped);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.wrapped = PolymorphicWritable.read(in, Mapping.class);
        }
    }

    public static final class SoftLimit
    extends Mapping {
        private double min;
        private double max;
        private double scale;

        public SoftLimit() {
        }

        private SoftLimit(double min, double max, double scale) {
            this.min = min;
            this.max = max;
            this.scale = scale;
        }

        @Override
        public double apply(double v) {
            return this.min + (this.max - this.min) * 1.0 / (1.0 + Math.exp(-v * this.scale));
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeDouble(this.min);
            out.writeDouble(this.max);
            out.writeDouble(this.scale);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.min = in.readDouble();
            this.max = in.readDouble();
            this.scale = in.readDouble();
        }
    }
}

