/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;

public final class SequenceFileDirValueIterator<V extends Writable>
extends ForwardingIterator<V>
implements Closeable {
    private static final FileStatus[] NO_STATUSES = new FileStatus[0];
    private Iterator<V> delegate;
    private final List<SequenceFileValueIterator<V>> iterators;

    public SequenceFileDirValueIterator(Path path, PathType pathType, PathFilter filter, Comparator<FileStatus> ordering, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get(path.toUri(), conf);
        FileStatus[] statuses = filter == null ? (pathType == PathType.GLOB ? fs.globStatus(path) : fs.listStatus(path)) : (pathType == PathType.GLOB ? fs.globStatus(path, filter) : fs.listStatus(path, filter));
        this.iterators = Lists.newArrayList();
        this.init(statuses, ordering, reuseKeyValueInstances, conf);
    }

    public SequenceFileDirValueIterator(Path[] path, Comparator<FileStatus> ordering, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        this.iterators = Lists.newArrayList();
        FileSystem fs = FileSystem.get(path[0].toUri(), conf);
        FileStatus[] statuses = new FileStatus[path.length];
        for (int i = 0; i < statuses.length; ++i) {
            statuses[i] = fs.getFileStatus(path[i]);
        }
        this.init(statuses, ordering, reuseKeyValueInstances, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(FileStatus[] statuses, Comparator<FileStatus> ordering, final boolean reuseKeyValueInstances, final Configuration conf) throws IOException {
        if (statuses == null) {
            statuses = NO_STATUSES;
        }
        if (ordering != null) {
            Arrays.sort(statuses, ordering);
        }
        UnmodifiableIterator<FileStatus> fileStatusIterator = Iterators.forArray(statuses);
        try {
            Iterator fsIterators = Iterators.transform(fileStatusIterator, new Function<FileStatus, Iterator<V>>(){

                @Override
                public Iterator<V> apply(FileStatus from) {
                    try {
                        SequenceFileValueIterator iterator = new SequenceFileValueIterator(from.getPath(), reuseKeyValueInstances, conf);
                        SequenceFileDirValueIterator.this.iterators.add(iterator);
                        return iterator;
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException(from.getPath().toString(), ioe);
                    }
                }
            });
            Collections.reverse(this.iterators);
            this.delegate = Iterators.concat(fsIterators);
        }
        finally {
            IOUtils.close(this.iterators);
        }
    }

    @Override
    protected Iterator<V> delegate() {
        return this.delegate;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.iterators);
    }
}

