/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public final class StringTuple
implements WritableComparable<StringTuple> {
    private List<String> tuple = Lists.newArrayList();

    public StringTuple() {
    }

    public StringTuple(String firstEntry) {
        this.add(firstEntry);
    }

    public StringTuple(Iterable<String> entries) {
        for (String entry : entries) {
            this.add(entry);
        }
    }

    public StringTuple(String[] entries) {
        for (String entry : entries) {
            this.add(entry);
        }
    }

    public boolean add(String entry) {
        return this.tuple.add(entry);
    }

    public String stringAt(int index) {
        return this.tuple.get(index);
    }

    public String replaceAt(int index, String newString) {
        return this.tuple.set(index, newString);
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(this.tuple);
    }

    public int length() {
        return this.tuple.size();
    }

    public String toString() {
        return this.tuple.toString();
    }

    public int hashCode() {
        return ((Object)this.tuple).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringTuple other = (StringTuple)obj;
        return !(this.tuple == null ? other.tuple != null : !((Object)this.tuple).equals(other.tuple));
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        this.tuple = Lists.newArrayListWithCapacity(len);
        Text value = new Text();
        for (int i = 0; i < len; ++i) {
            value.readFields(in);
            this.tuple.add(value.toString());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.tuple.size());
        Text value = new Text();
        for (String entry : this.tuple) {
            value.set(entry);
            value.write(out);
        }
    }

    @Override
    public int compareTo(StringTuple otherTuple) {
        int thisLength = this.length();
        int otherLength = otherTuple.length();
        int min = Math.min(thisLength, otherLength);
        for (int i = 0; i < min; ++i) {
            int ret = this.tuple.get(i).compareTo(otherTuple.stringAt(i));
            if (ret == 0) continue;
            return ret;
        }
        if (thisLength < otherLength) {
            return -1;
        }
        if (thisLength > otherLength) {
            return 1;
        }
        return 0;
    }
}

