/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.lucene.AnalyzerUtils;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    private Option inputOption;
    private Option outputOption;
    protected Path inputPath;
    protected File inputFile;
    protected Path outputPath;
    protected File outputFile;
    protected Path tempPath;
    protected Map<String, List<String>> argMap;
    private final List<Option> options = Lists.newLinkedList();
    private Group group;

    protected AbstractJob() {
    }

    protected Path getInputPath() {
        return this.inputPath;
    }

    protected Path getOutputPath() {
        return this.outputPath;
    }

    protected Path getOutputPath(String path) {
        return new Path(this.outputPath, path);
    }

    protected File getInputFile() {
        return this.inputFile;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    protected Path getTempPath() {
        return this.tempPath;
    }

    protected Path getTempPath(String directory) {
        return new Path(this.tempPath, directory);
    }

    @Override
    public Configuration getConf() {
        Configuration result = super.getConf();
        if (result == null) {
            return new Configuration();
        }
        return result;
    }

    protected void addFlag(String name, String shortName, String description) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, false, false, null));
    }

    protected void addOption(String name, String shortName, String description) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, false, null));
    }

    protected void addOption(String name, String shortName, String description, boolean required) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, required, null));
    }

    protected void addOption(String name, String shortName, String description, String defaultValue) {
        this.options.add(AbstractJob.buildOption(name, shortName, description, true, false, defaultValue));
    }

    protected Option addOption(Option option) {
        this.options.add(option);
        return option;
    }

    protected Group getGroup() {
        return this.group;
    }

    protected void addInputOption() {
        this.inputOption = this.addOption(DefaultOptionCreator.inputOption().create());
    }

    protected void addOutputOption() {
        this.outputOption = this.addOption(DefaultOptionCreator.outputOption().create());
    }

    protected static Option buildOption(String name, String shortName, String description, boolean hasArg, boolean required, String defaultValue) {
        return AbstractJob.buildOption(name, shortName, description, hasArg, 1, 1, required, defaultValue);
    }

    protected static Option buildOption(String name, String shortName, String description, boolean hasArg, int min, int max, boolean required, String defaultValue) {
        DefaultOptionBuilder optBuilder = new DefaultOptionBuilder().withLongName(name).withDescription(description).withRequired(required);
        if (shortName != null) {
            optBuilder.withShortName(shortName);
        }
        if (hasArg) {
            ArgumentBuilder argBuilder = new ArgumentBuilder().withName(name).withMinimum(min).withMaximum(max);
            if (defaultValue != null) {
                argBuilder = argBuilder.withDefault(defaultValue);
            }
            optBuilder.withArgument(argBuilder.create());
        }
        return optBuilder.create();
    }

    protected Option getCLIOption(String name) {
        for (Option option : this.options) {
            if (!option.getPreferredName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public Map<String, List<String>> parseArguments(String[] args) throws IOException {
        return this.parseArguments(args, false, false);
    }

    public Map<String, List<String>> parseArguments(String[] args, boolean inputOptional, boolean outputOptional) throws IOException {
        CommandLine cmdLine;
        Option helpOpt = this.addOption(DefaultOptionCreator.helpOption());
        this.addOption("tempDir", null, "Intermediate output directory", "temp");
        this.addOption("startPhase", null, "First phase to run", "0");
        this.addOption("endPhase", null, "Last phase to run", String.valueOf(Integer.MAX_VALUE));
        GroupBuilder gBuilder = new GroupBuilder().withName("Job-Specific Options:");
        for (Option opt : this.options) {
            gBuilder = gBuilder.withOption(opt);
        }
        this.group = gBuilder.create();
        try {
            Parser parser = new Parser();
            parser.setGroup(this.group);
            parser.setHelpOption(helpOpt);
            cmdLine = parser.parse(args);
        }
        catch (OptionException e) {
            log.error(e.getMessage());
            CommandLineUtil.printHelpWithGenericOptions(this.group, e);
            return null;
        }
        if (cmdLine.hasOption(helpOpt)) {
            CommandLineUtil.printHelpWithGenericOptions(this.group);
            return null;
        }
        try {
            this.parseDirectories(cmdLine, inputOptional, outputOptional);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            CommandLineUtil.printHelpWithGenericOptions(this.group);
            return null;
        }
        this.argMap = new TreeMap<String, List<String>>();
        AbstractJob.maybePut(this.argMap, cmdLine, this.options.toArray(new Option[this.options.size()]));
        this.tempPath = new Path(this.getOption("tempDir"));
        if (!this.hasOption("quiet")) {
            log.info("Command line arguments: {}", this.argMap);
        }
        return this.argMap;
    }

    public static String keyFor(String optionName) {
        return "--" + optionName;
    }

    public String getOption(String optionName) {
        List<String> list = this.argMap.get(AbstractJob.keyFor(optionName));
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public String getOption(String optionName, String defaultVal) {
        String res = this.getOption(optionName);
        if (res == null) {
            res = defaultVal;
        }
        return res;
    }

    public int getInt(String optionName) {
        return Integer.parseInt(this.getOption(optionName));
    }

    public int getInt(String optionName, int defaultVal) {
        return Integer.parseInt(this.getOption(optionName, String.valueOf(defaultVal)));
    }

    public float getFloat(String optionName) {
        return Float.parseFloat(this.getOption(optionName));
    }

    public float getFloat(String optionName, float defaultVal) {
        return Float.parseFloat(this.getOption(optionName, String.valueOf(defaultVal)));
    }

    public List<String> getOptions(String optionName) {
        return this.argMap.get(AbstractJob.keyFor(optionName));
    }

    public boolean hasOption(String optionName) {
        return this.argMap.containsKey(AbstractJob.keyFor(optionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDimensions(Path matrix) throws IOException {
        int n;
        SequenceFile.Reader reader = null;
        try {
            reader = new SequenceFile.Reader(FileSystem.get(this.getConf()), matrix, this.getConf());
            Writable row = ClassUtils.instantiateAs(reader.getKeyClass().asSubclass(Writable.class), Writable.class);
            Preconditions.checkArgument(reader.getValueClass().equals(VectorWritable.class), "value type of sequencefile must be a VectorWritable");
            VectorWritable vectorWritable = new VectorWritable();
            boolean hasAtLeastOneRow = reader.next(row, vectorWritable);
            Preconditions.checkState(hasAtLeastOneRow, "matrix must have at least one row");
            n = vectorWritable.get().size();
        }
        catch (Throwable throwable) {
            Closeables.close(reader, true);
            throw throwable;
        }
        Closeables.close(reader, true);
        return n;
    }

    protected void parseDirectories(CommandLine cmdLine, boolean inputOptional, boolean outputOptional) {
        Configuration conf = this.getConf();
        if (this.inputOption != null && cmdLine.hasOption(this.inputOption)) {
            this.inputPath = new Path(cmdLine.getValue(this.inputOption).toString());
            this.inputFile = new File(cmdLine.getValue(this.inputOption).toString());
        }
        if (this.inputPath == null && conf.get("mapred.input.dir") != null) {
            this.inputPath = new Path(conf.get("mapred.input.dir"));
        }
        if (this.outputOption != null && cmdLine.hasOption(this.outputOption)) {
            this.outputPath = new Path(cmdLine.getValue(this.outputOption).toString());
            this.outputFile = new File(cmdLine.getValue(this.outputOption).toString());
        }
        if (this.outputPath == null && conf.get("mapred.output.dir") != null) {
            this.outputPath = new Path(conf.get("mapred.output.dir"));
        }
        Preconditions.checkArgument(inputOptional || this.inputOption == null || this.inputPath != null, "No input specified or -Dmapred.input.dir must be provided to specify input directory");
        Preconditions.checkArgument(outputOptional || this.outputOption == null || this.outputPath != null, "No output specified:  or -Dmapred.output.dir must be provided to specify output directory");
    }

    protected static void maybePut(Map<String, List<String>> args, CommandLine cmdLine, Option ... opt) {
        for (Option o : opt) {
            if (!cmdLine.hasOption(o) && cmdLine.getValue(o) == null && (cmdLine.getValues(o) == null || cmdLine.getValues(o).isEmpty())) continue;
            List vo = cmdLine.getValues(o);
            if (vo != null && !vo.isEmpty()) {
                ArrayList<String> vals = Lists.newArrayList();
                for (Object o1 : vo) {
                    vals.add(o1.toString());
                }
                args.put(o.getPreferredName(), vals);
                continue;
            }
            args.put(o.getPreferredName(), null);
        }
    }

    public static String getOption(Map<String, List<String>> args, String optName) {
        List<String> res = args.get(optName);
        if (res != null && !res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    protected static boolean shouldRunNextPhase(Map<String, List<String>> args, AtomicInteger currentPhase) {
        boolean phaseSkipped;
        int phase = currentPhase.getAndIncrement();
        String startPhase = AbstractJob.getOption(args, "--startPhase");
        String endPhase = AbstractJob.getOption(args, "--endPhase");
        boolean bl = phaseSkipped = startPhase != null && phase < Integer.parseInt(startPhase) || endPhase != null && phase > Integer.parseInt(endPhase);
        if (phaseSkipped) {
            log.info("Skipping phase {}", (Object)phase);
        }
        return !phaseSkipped;
    }

    protected Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends OutputFormat> outputFormat) throws IOException {
        return this.prepareJob(inputPath, outputPath, inputFormat, mapper, mapperKey, mapperValue, outputFormat, (String)null);
    }

    protected Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends OutputFormat> outputFormat, String jobname) throws IOException {
        Job job = HadoopUtil.prepareJob(inputPath, outputPath, inputFormat, mapper, mapperKey, mapperValue, outputFormat, this.getConf());
        String name = jobname != null ? jobname : HadoopUtil.getCustomJobName(this.getClass().getSimpleName(), job, mapper, Reducer.class);
        job.setJobName(name);
        return job;
    }

    protected Job prepareJob(Path inputPath, Path outputPath, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends Reducer> reducer, Class<? extends Writable> reducerKey, Class<? extends Writable> reducerValue) throws IOException {
        return this.prepareJob(inputPath, outputPath, SequenceFileInputFormat.class, mapper, mapperKey, mapperValue, reducer, reducerKey, reducerValue, SequenceFileOutputFormat.class);
    }

    protected Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends Reducer> reducer, Class<? extends Writable> reducerKey, Class<? extends Writable> reducerValue, Class<? extends OutputFormat> outputFormat) throws IOException {
        Job job = HadoopUtil.prepareJob(inputPath, outputPath, inputFormat, mapper, mapperKey, mapperValue, reducer, reducerKey, reducerValue, outputFormat, this.getConf());
        job.setJobName(HadoopUtil.getCustomJobName(this.getClass().getSimpleName(), job, mapper, Reducer.class));
        return job;
    }

    public static void setS3SafeCombinedInputPath(Job job, Path referencePath, Path inputPathOne, Path inputPathTwo) throws IOException {
        FileSystem fs = FileSystem.get(referencePath.toUri(), job.getConfiguration());
        FileInputFormat.setInputPaths(job, inputPathOne.makeQualified(fs), inputPathTwo.makeQualified(fs));
    }

    protected Class<? extends Analyzer> getAnalyzerClassFromOption() throws ClassNotFoundException {
        Class analyzerClass = StandardAnalyzer.class;
        if (this.hasOption("analyzerName")) {
            String className = this.getOption("analyzerName");
            analyzerClass = Class.forName(className).asSubclass(Analyzer.class);
            AnalyzerUtils.createAnalyzer(analyzerClass);
        }
        return analyzerClass;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        String oozieActionConfXml = System.getProperty("oozie.action.conf.xml");
        if (oozieActionConfXml != null && conf != null) {
            conf.addResource(new Path("file:///", oozieActionConfXml));
            log.info("Added Oozie action Configuration resource {} to the Hadoop Configuration", (Object)oozieActionConfXml);
        }
    }
}

