/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterCountReader;
import org.apache.mahout.math.VectorWritable;

public class ClusterOutputPostProcessorReducer
extends Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
    private Map<Integer, Integer> reverseClusterMappings;

    @Override
    public void setup(Reducer.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        Path clusterOutputPath = new Path(conf.get("clusterOutputPath"));
        this.reverseClusterMappings = ClusterCountReader.getClusterIDs(clusterOutputPath, conf, false);
    }

    @Override
    protected void reduce(IntWritable key, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        IntWritable outKey = new IntWritable(this.reverseClusterMappings.get(key.get()));
        System.out.println(outKey + " this: " + this);
        for (VectorWritable value : values) {
            context.write(outKey, value);
        }
    }
}

