/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterCountReader;
import org.apache.mahout.math.VectorWritable;

public class ClusterOutputPostProcessorMapper
extends Mapper<IntWritable, WeightedVectorWritable, IntWritable, VectorWritable> {
    private Map<Integer, Integer> newClusterMappings;
    private VectorWritable outputVector;

    @Override
    public void setup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        Path clusterOutputPath = new Path(conf.get("clusterOutputPath"));
        this.newClusterMappings = ClusterCountReader.getClusterIDs(clusterOutputPath, conf, true);
        this.outputVector = new VectorWritable();
    }

    @Override
    public void map(IntWritable key, WeightedVectorWritable val, Mapper.Context context) throws IOException, InterruptedException {
        this.outputVector.set(val.getVector());
        context.write(new IntWritable(this.newClusterMappings.get(key.get())), this.outputVector);
    }
}

