/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.canopy;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.conversion.InputDriver;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
extends AbstractJob {
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";
    private static final Logger log = LoggerFactory.getLogger(Job.class);

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run(new Configuration(), new Job(), args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            HadoopUtil.delete(new Configuration(), output);
            Job.run(new Path("testdata"), output, new EuclideanDistanceMeasure(), 80.0, 55.0);
        }
    }

    private static void run(Path input, Path output, DistanceMeasure measure, double t1, double t2) throws Exception {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        InputDriver.runJob(input, directoryContainingConvertedInput, "org.apache.mahout.math.RandomAccessSparseVector");
        CanopyDriver.run(new Configuration(), directoryContainingConvertedInput, output, measure, t1, t2, true, 0.0, false);
        ClusterDumper clusterDumper = new ClusterDumper(new Path(output, "clusters-0-final"), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }

    @Override
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption(DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption(DefaultOptionCreator.t1Option().create());
        this.addOption(DefaultOptionCreator.t2Option().create());
        this.addOption(DefaultOptionCreator.overwriteOption().create());
        Map<String, List<String>> argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(new Configuration(), output);
        }
        String measureClass = this.getOption("distanceMeasure");
        double t1 = Double.parseDouble(this.getOption("t1"));
        double t2 = Double.parseDouble(this.getOption("t2"));
        DistanceMeasure measure = ClassUtils.instantiateAs(measureClass, DistanceMeasure.class);
        Job.run(input, output, measure, t1, t2);
        return 0;
    }
}

